% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_tts_auth.R
\name{get_ms_tts_key}
\alias{get_ms_tts_key}
\alias{have_ms_tts_key}
\alias{set_ms_tts_key}
\alias{valid_ms_tts_key}
\title{Find API Key for Microsoft Text To Speech (TTS) or Cognitive
Services}
\usage{
get_ms_tts_key(api_key = NULL, error = TRUE)

have_ms_tts_key(api_key = NULL)

set_ms_tts_key(api_key)

valid_ms_tts_key(api_key = NULL)
}
\arguments{
\item{api_key}{Microsoft Cognitive Services API key}

\item{error}{Should the function error if \code{api_key = NULL}?}
}
\value{
API key
}
\description{
Determines if \code{option(ms_tts_key)} or
\code{option(ms_tts_key)} is set.
If not, it stops and returns an error.  If so, returns the value.
}
\note{
You can either set the API key using
\code{option(ms_tts_key)} or have it accessible by
\code{api_key = Sys.getenv('MS_TTS_API_KEY")}, or
\code{api_key = Sys.getenv('MS_TTS_API_KEY1")}, or
\code{api_key = Sys.getenv('MS_TTS_API_KEY2")}
}
\examples{
res = get_ms_tts_key(error = FALSE)
}
