% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ssml.R
\name{create_ssml}
\alias{create_ssml}
\title{Create SSML for Passing to Synthesize}
\usage{
create_ssml(script, gender = c("Female", "Male"), language = "en-US",
  escape = FALSE)
}
\arguments{
\item{script}{A character vector of lines to be spoken}

\item{gender}{Sex of the Speaker}

\item{language}{Language to be spoken,
must be from \code{\link{ms_language_codes}}}

\item{escape}{Should non-standard characters be substituted?  Should not
be used if \code{script} has SSML tags}
}
\value{
A character string of the text and SSML markup
}
\description{
Create SSML for Passing to Synthesize
}
\examples{
create_ssml("hey I really like things & dogs", escape = TRUE)
create_ssml("hey I really like things")
create_ssml('hey I <emphasis level="strong">really like</emphasis> things')
create_ssml('hey I <emphasis level="strong">really like</emphasis> things',
escape = TRUE)

}
