% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse_saeRB.R
\name{mse_saeRB}
\alias{mse_saeRB}
\title{Parametric Bootstrap Mean Squared Error Estimators of Ratio Benchmarking for Univariate Small Area Estimation}
\usage{
mse_saeRB(
  formula,
  vardir,
  weight,
  samevar = FALSE,
  B = 1000,
  MAXITER = 100,
  PRECISION = 1e-04,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula describe the fitted model}

\item{vardir}{vector containing sampling variances of direct estimators}

\item{weight}{vector containing proportion of units in small areas}

\item{samevar}{logical. If \code{TRUE}, the varians is same. Default is \code{FALSE}}

\item{B}{number of bootstrap. Default is 1000}

\item{MAXITER}{maximum number of iterations for Fisher-scoring. Default is 100}

\item{PRECISION}{coverage tolerance limit for the Fisher Scoring algorithm. Default value is \code{1e-4}}

\item{data}{dataframe containing the variables named in formula, vardir, and weight}
}
\value{
\item{mse.eblup}{estimated mean squared errors of the EBLUPs for the small domains based on Prasad Rao}
\item{pbmse.eblupRB}{parametric bootstrap mean squared error estimates of the ratio benchmark}
\item{running.time}{time for running function}
}
\description{
Calculates the parametric bootstrap mean squared error estimates of ratio benchmarking for univariate small area estimation
}
\examples{
\donttest{
## load dataset
data(datamsaeRB)

# Compute MSE EBLUP and Ratio Benchmark

## Using parameter 'data'
mse_sae = mse_saeRB(Y1 ~ X1 + X2, v1, w1, data = datamsaeRB)

## Without parameter 'data'
mse_sae = mse_saeRB(datamsaeRB$Y1 ~ datamsaeRB$X1 + datamsaeRB$X2, datamsaeRB$v1, datamsaeRB$w1)

## Return
mse_sae$pbmse.eblupRB # to see the MSE Ratio Benchmark estimators
}
}
