########################################################
## msProcess package attachment functions
##
##  .First.lib
##
########################################################

if (!is.R()) {

  ###
  # .First.lib
  ###

  .First.lib <- function(library, section)
  {
	### Load the GUI if appropriate
	if(is.sgui.app() && interactive() && 
		require(pkgutils) && (getSversion() >= '8.1')) {
		## load msProcess menu
		loadMSMenu()
		## load msProcess dialog properties and FunctionInfo objects
		loadMSProps()
	} 
	
	## moved out of the following if statement to avoid the warning 
	## generated by the robust library, see Bug # 49345 for details
	   # robust library
	   robust.pos <- attached.where("robust", nomatch=0)
	   if (!robust.pos) {
	     cat("Loading required package robust\n")
	     library("robust", first=TRUE)
	   }
	
	# DependsSplus in DESCRIPTION file does not work for S-PLUS version < '8.1'
	if (require(pkgutils) && getSversion() < '8.1') {
	   ## load required S-PLUS base libraries
	
	   # SPXML library
	   SPXML.pos <- attached.where("SPXML", nomatch=0)
	   if (!SPXML.pos) {
	     cat("Loading required package SPXML\n")
	     library("SPXML")
	   }
	
	   ## load required S-PLUS CSAN packages and install if necessary
	    
	   # create a temporary installation directory for install.packages() calls.
	   # setting destdir explicitly in install.packages() avoids a message printed 
	   # to the command line defining where the temporary installation took place.
	   tmpdir <- file.path(tempfile("dir"), "downloaded_packages")
	   if(!file.exists(tmpdir) && !dir.create(tmpdir, recursive=T))
	     stop(sprintf("Unable to create temporary directory '%s'", tmpdir))
	
	   "quietRequire" <- function(package){
	     if (!is.character(package) || length(package) > 1)
	       stop("package must be a scalar character string")
	     package <- as.character(substitute(package))
	     val <- try(library(package, character.only=T))
	     return(!inherits(val, "Error"))
	   }
	
	   # pkgutils
	   pkgutils.pos <- attached.where("pkgutils", nomatch=0)
	   if (!pkgutils.pos) {
	     dscfile <- system.file(package="pkgutils", "DESCRIPTION")
	     if (!file.exists(dscfile)) {
	       cat("Updating required package pkgutils\n")
	       install.pkgutils(update=T)
	   }
	
	     cat("Loading required package pkgutils\n")
	     library("pkgutils")
	   }
	
	   # ifultools
	   ifultools.pos <- attached.where("ifultools", nomatch=0)
	   if (!ifultools.pos) {
	     if (!quietRequire("ifultools")) {
	       cat("Installing required package ifultools.\n")
	       install.packages("ifultools", lib=.libPaths()[1], destdir=tmpdir)
	     }
	
	     cat("Loading required package ifultools\n")
	     library("ifultools")
	   }
	
	   # wmtsa
	   wmtsa.pos <- attached.where("wmtsa", nomatch=0)
	   if (!wmtsa.pos) {
	     if (!quietRequire("wmtsa")) {
	       cat("Installing required package wmtsa.\n")
	       install.packages("wmtsa", lib=.libPaths()[1], destdir=tmpdir)
	     }
	
	     cat("Loading required package wmtsa\n")
	     library("wmtsa")
	   }
	
	   # DBI
	   DBI.pos <- attached.where("DBI", nomatch=0)
	   if (!DBI.pos) {
	     if (!quietRequire("DBI")) {
	       cat("Installing required package DBI.\n")
	       install.packages("DBI", lib=.libPaths()[1], destdir=tmpdir)
	     }
	
	     cat("Loading required package DBI\n")
	     library("DBI")
	   }
	
	   # RSQLite
	   RSQLite.pos <- attached.where("RSQLite", nomatch=0)
	   if (!RSQLite.pos) {
	     if (!quietRequire("RSQLite")) {
	       cat("Installing required package RSQLite.\n")
	       install.packages("RSQLite", lib=.libPaths()[1], destdir=tmpdir)
	     }
	
	     cat("Loading required package RSQLite\n")
	     library("RSQLite")
	   }
	}

   invisible(NULL)
 }

   .Last.lib <- function(library, section, .data, where)
  {
	  if (is.sgui.app() && interactive() && is.element("SPlusMenuBar$SplusMSProcess", guiGetObjectNames("MenuItem")))
	    guiRemove("MenuItem", Name="SPlusMenuBar$SplusMSProcess")  
	 
	  invisible(NULL)
  }

} # end is.R() check
