% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrfi_class.R, R/mrfi_methods.R
\docType{class}
\name{mrfi-class}
\alias{mrfi-class}
\alias{as.list,mrfi-method}
\alias{[[,mrfi,numeric,missing-method}
\alias{[,mrfi,numeric,missing-method}
\alias{+,mrfi,numeric-method}
\alias{+,mrfi,mrfi-method}
\title{mrfi: MRF interaction structure}
\usage{
\S4method{as.list}{mrfi}(x)

\S4method{[[}{mrfi,numeric,missing}(x, i)

\S4method{[}{mrfi,numeric,missing}(x, i)

\S4method{+}{mrfi,numeric}(e1, e2)

\S4method{+}{mrfi,mrfi}(e1, e2)
}
\arguments{
\item{x}{\code{mrfi} object.}

\item{i}{vector of indexes to extract interacting positions.}

\item{e1}{A \code{mrfi} object.}

\item{e2}{Either a second \code{mrfi} object or a length 2 \code{numeric} with the new
relative position to include.}
}
\value{
\code{as.list()}: converts the \code{mrfi} object to a list of interacting
positions (length 2 vectors).

\verb{[[}: converts to list and subsets it.

\verb{[}: subsets the \code{mrfi} object and returns another \code{mrfi} object.

\verb{+}: computes the union of the interaction structure in a \code{mrfi} object with
a \code{numeric} representing an additional position to include or another \code{mrfi}
object.
}
\description{
The \code{mrfi} S4 class is a representation of the interaction
structure for a spatially-stationary Markov Random Field.

The function \code{\link[=mrfi]{mrfi()}} provides an interface for creation
\code{mrfi} objects. A \code{plot} method is also available for visualization, as
well as conversion methods like \code{as.list} and operators like \verb{+}.
}
\details{
The interaction structure is defined by the list of relative
positions in it. For a specific pixel, conditional to the values of pixels in
these relative positions from it, its value is independent of any other pixel
in the image.

The relative positions are indentified by two integers \code{rx} and \code{ry}
representing the "shift" in the \code{x}-axis and \code{y}-axis respectively. As an
example: The relative position \verb{(1,0)} representes the pixel in the immediate
right position, while \verb{(-1,0)} the left one.

Note that the inclusion of a relative position to the dependence also implies
its opposite direction is not conditionally independent (commutativeness of
dependence), but only one is actually included to the \code{mrfi} object.

To illustrate that, a nearest neighbor dependence structure can be specified
by:

\code{mrfi(1)}

Note that it only includes the positions \verb{(1,0)} and \verb{(0,1)}, but when
visualizing it, for example, \code{mrf2d} understands the opposite directions
are also conditionally dependent, as in

\code{plot(mrfi(1))}.
}
\section{Slots}{

\describe{
\item{\code{Rmat}}{A 2-column \code{matrix} where each row represents a relative position
of interaction.}
}}

\examples{
plot(mrfi(max_norm = 2, norm_type = "1"))
plot(mrfi(max_norm = 2, norm_type = "m"))
plot(mrfi(max_norm = 2, norm_type = "1", positions = list(c(4,4))))

as.list(mrfi(1))
mrfi(1)[[1]]
mrfi(2)[[1:3]]

mrfi(1) + c(2,0)
mrfi(1) + mrfi(0, positions = list(c(2,0)))
}
