% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_pred_R2.R
\name{QTL_pred_R2}
\alias{QTL_pred_R2}
\title{Predicted QTL global and partial R squared}
\usage{
QTL_pred_R2(
  mppData.ts,
  mppData.vs,
  trait = 1,
  Q.eff = "cr",
  QTL = NULL,
  her = 1
)
}
\arguments{
\item{mppData.ts}{An object of class \code{mppData} for the training set.}

\item{mppData.vs}{An object of class \code{mppData} for the validation set.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental; 3) "anc"
for ancestral; 4) "biall" for a bi-allelic. For more details see
\code{\link{mpp_SIM}}. Default = "cr".}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected position obtained with the function \code{\link{QTL_select}} or
vector of \code{character} marker positions names.
Default = NULL.}

\item{her}{\code{Numeric} value between 0 and 1 representing the heritability
of the trait. \code{her} can be a single value or a vector specifying each
within cross heritability. Default = 1.}
}
\value{
Return:

\code{List} containing the following objects:

\item{glb.R2 }{Global predicted R squared corrected for the heritability
of all QTL terms. Doing the average of the within cross predicted R squared
(R2.cr)}

\item{R2.cr}{Within cross predicted R squared corrected for the heritability}

\item{part.R2.diff }{ Vector of predicted partial R squared corrected
for the heritability doing the difference between the full model and a model
minus the ith QTL.}
}
\description{
Compute predicted R squared in a validation set using QTLs detected in a
training set. These values are corrected by the heritability \code{her}.
}
\details{
Compute QTLs predicted R squared in a validation set  (\code{mppData.vs}).
These QTLs have been previously detected in a training set
(\code{mppData.ts}). The global R squared (R2 = cor(y.ts,y.pred.ts)^2) is
obtained using the Pearson squared correlation between the observed trait
values in the validation set (y.vs) and predicted values using estimated QTL
effects in the training set (y.pred.vs = X.vs * B.ts).

After that the values are corrected by the general or within cross
heritability \code{her}. By default \code{her = 1} which means that the
R squared represent the proportion of explained phenotypic variance. The
values are returned per cross (\code{R2.cr}) or averaged at the population
level (\code{glb.R2}).

Partial R squared statistics are also calculated for each individual position.
The partial R squared are computed by making the difference between the
global R squared and the R squared computed without the ith position.
}
\examples{

data(mppData)

folds <- CV_partition(cross.ind = mppData$cross.ind, k = 5)

mppData.ts <- subset(x = mppData, gen.list = folds[[1]]$train.set)

mppData.vs <- subset(x = mppData, gen.list = folds[[1]]$val.set)

SIM <- mpp_SIM(mppData = mppData)
QTL <- QTL_select(SIM)

QTL_pred_R2(mppData.ts = mppData.ts, mppData.vs = mppData.vs, QTL = QTL)

}
\seealso{
\code{\link{QTL_R2}}, \code{\link{QTL_select}}
}
\author{
Vincent Garin
}
