% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpp_CIM.R
\name{mpp_CIM}
\alias{mpp_CIM}
\title{MPP Composite Interval Mapping}
\usage{
mpp_CIM(mppData, trait = 1, Q.eff = "cr", cofactors = NULL,
  window = 20, plot.gen.eff = FALSE, n.cores = 1)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental; 3) "anc"
for ancestral; 4) "biall" for a bi-allelic. For more details see
\code{\link{mpp_SIM}}. Default = "cr".}

\item{cofactors}{Object of class \code{QTLlist} representing a list of
selected position obtained with the function \code{\link{QTL_select}} or
vector of \code{character} marker positions names.
Default = NULL.}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 20.}

\item{plot.gen.eff}{\code{Logical} value. If \code{plot.gen.eff = TRUE},
the function will save the decomposed genetic effects per cross/parent.
These results can be plotted with the function \code{\link{plot.QTLprof}}
to visualize a genome-wide decomposition of the genetic effects.
\strong{This functionality is only available for the cross-specific,
parental and ancestral models.}
Default value = FALSE.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}
}
\value{
Return:

\item{CIM }{\code{Data.frame} of class \code{QTLprof}. with five columns :
1) QTL marker names; 2) chromosomes;
3) interger position indicators on the chromosome;
4) positions in centi-Morgan; and 5) -log10(p-val). And if
\code{plot.gen.eff = TRUE}, p-values of the cross or parental QTL effects.}
}
\description{
Compute QTL models along the genome using cofactors representing other
genetic positions for control.
}
\details{
For more details about the different models, see documentation of the
function \code{\link{mpp_SIM}}. The function returns a -log10(p-value) QTL
profile.
}
\examples{

# Cross-specific effect model
#############################

data(mppData)

SIM <- mpp_SIM(mppData = mppData, Q.eff = "cr")

cofactors <- QTL_select(Qprof = SIM, threshold = 3, window = 20)

CIM <- mpp_CIM(mppData = mppData, Q.eff = "cr", cofactors = cofactors,
               window = 20, plot.gen.eff = TRUE)

plot(x = CIM)
plot(x = CIM, gen.eff = TRUE, mppData = mppData, Q.eff = "cr")

# Bi-allelic model
##################

cofactors <- mppData$map[c(15, 63), 1]

CIM <- mpp_CIM(mppData = mppData, Q.eff = "biall", cofactors = cofactors,
               window = 20)

plot(x = CIM, type = "h")
                               
}
\seealso{
\code{\link{mpp_SIM}}, \code{\link{QTL_select}}
}
\author{
Vincent Garin
}
