% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/as.function.mpoly.R
\name{as.function.mpoly}
\alias{as.function.mpoly}
\title{Change a multivariate polynomial into a function.}
\usage{
\method{as.function}{mpoly}(x, varorder = vars(x), vector = TRUE, ...)
}
\arguments{
\item{x}{an object of class mpoly}

\item{varorder}{the order in which the arguments of the function will be
provided}

\item{vector}{whether the function should take a vector argument (TRUE) or a
series of arguments (FALSE)}

\item{...}{any additional arguments}
}
\description{
Transforms an mpoly object into a function which can be evaluated.
}
\examples{
mpoly <- mp('1 2 3 4')
f <- as.function(mpoly)
f(10) # -> 24
mpoly <- mp('x + 3 x y + z^2 x')
f <- as.function(mpoly)
f(1:3) # -> 16
f(c(1,1,1)) # -> 5

f <- as.function(mpoly, vector = FALSE)
f(1, 2, 3) # -> 16
f(1, 1, 1) # -> 5

f <- as.function(mpoly, varorder = c('z','y','x'), vector = FALSE)
f(3, 2, 1) # -> 16
f(1, 1, 1) # -> 5
}

