% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{plot.coverage}
\alias{plot.coverage}
\title{Plot a coverage overview}
\usage{
\method{plot}{coverage}(x, ...)
}
\arguments{
\item{x}{A tibble with the coverage data coming from \code{\link[=coverage]{coverage()}}.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plot a coverage overview
}
\examples{
\dontrun{
freq <- c(
  Accelerometer = 720, # Once per 5 seconds. Can have multiple measurements.
  AirQuality = 1,
  AppUsage = 2, # Once every 30 minutes
  Bluetooth = 60, # Once per minute. Can have multiple measurements.
  Gyroscope = 720, # Once per 5 seconds. Can have multiple measurements.
  Light = 360, # Once per 10 seconds
  Location = 60, # Once per 60 seconds
  Memory = 60, # Once per minute
  Noise = 120,
  Pedometer = 1,
  Weather = 1,
  Wifi = 60 # once per minute
)

data <- coverage(
  db = db,
  participant_id = "12345",
  sensor = c("Accelerometer", "Gyroscope"),
  frequency = mpathsenser::freq,
  start_date = "2021-01-01",
  end_date = "2021-05-01"
)

plot(data)
}
}
\seealso{
\code{\link[=coverage]{coverage()}}
}
