% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_frametimes.R
\name{get_frametimes}
\alias{get_frametimes}
\title{Get frame times from frames}
\usage{
get_frametimes(frames)
}
\arguments{
\item{frames}{list, list of frames created using \code{\link{frames_spatial}} or \code{\link{frames_graph}}.}
}
\value{
A POSIXct vector of timestamps representing the time assoicated with each frame in \code{frames}.
}
\description{
This function extracts the timestamps associated with each frame of a list of frames created using \code{\link{frames_spatial}} or \code{\link{frames_graph}} and returns them as a vector.
}
\details{
\code{moveVis} stores the times represented by a frame as an attribute \code{"time"} for each \code{ggplot} frame.
}
\examples{
library(moveVis)
library(move)

data("move_data")
# align movement
m <- align_move(move_data, res = 4, unit = "mins")

\donttest{
frames <- frames_spatial(m, map_service = "osm", map_type = "watercolor")
frames.ts <- get_frametimes(frames)
print(frames.ts)
}

}
\seealso{
\code{\link{frames_spatial}} \code{\link{frames_graph}}
}
