% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_text.R
\name{add_text}
\alias{add_text}
\title{Add static or dynamic text to frames}
\usage{
add_text(frames, labels, x, y, colour = "black", size = 3,
  type = "text", verbose = TRUE)
}
\arguments{
\item{frames}{list of \code{ggplot2} objects, crated with \code{\link{frames_spatial}}.}

\item{labels}{character, text to be added to frames. Either a single character value or a character vector of same length as \code{frames}.}

\item{x}{numeric, position of text on the x scale. Either a single numeric value or a numeric vector of same length as \code{frames}.}

\item{y}{numeric, position of text on the y scale. Either a single numeric value or a numeric vector of same length as \code{frames}.}

\item{colour}{character, the text colour(s). Either a single character value or a character vector of same length as \code{frames}.}

\item{size}{numeric, the text size(s). Either a single numeric value or a numeric vector of same length as \code{frames}.}

\item{type}{character, either \code{"text"} to draw text or \code{"label"} to draw text inside a box.}

\item{verbose}{logical, if \code{TRUE}, messages on the function's progress are displayed (default).}
}
\value{
List of frames.
}
\description{
This function adds static or dynamically changing text to the animation frames created with \code{\link{frames_spatial}}.
}
\examples{
library(moveVis)
library(move)

data("move_data", "basemap_data")
m <- align_move(move_data, res = 4, unit = "mins")

# create spatial frames using a custom NDVI base layer
r_list <- basemap_data[[1]]
r_times <- basemap_data[[2]]

\donttest{
frames <- frames_spatial(m, r_list = r_list, r_times = r_times, r_type = "gradient",
                         fade_raster = TRUE)

# add text somewhere to all frames:
frames.a <- add_text(frames, "Water area", x = 8.959, y = 47.7305,
                     colour = "white", size = 3)
frames.a[[100]]

# or use the ggplot2 "label" type:
frames.b <- add_text(frames, "Water area", x = 8.959, y = 47.7305,
                     colour = "black", size = 3, type = "label")
frames.b[[100]]
}

}
\seealso{
\code{\link{frames_spatial}} \code{\link{frames_graph}} \code{\link{animate_frames}}
}
\author{
Jakob Schwalb-Willmann
}
