% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPR.R
\name{plotPR}
\alias{plotPR}
\title{Plot pseudo-residuals}
\usage{
plotPR(m)
}
\arguments{
\item{m}{A \code{\link{moveHMM}} object}
}
\description{
Plots time series, qq-plots (against the standard normal distribution), and sample
ACF functions of the pseudo-residuals
}
\details{
\itemize{
\item If some turning angles in the data are equal to pi, the corresponding pseudo-residuals
will not be included. Indeed, given that the turning angles are defined on (-pi,pi], an angle of pi
results in a pseudo-residual of +Inf (check Section 6.2 of reference for more information on the
computation of pseudo-residuals).
\item If some steps are of length zero (i.e. if there is zero-inflation), the corresponding pseudo-
residuals are shown as segments, because pseudo-residuals for discrete data are defined as
segments (see Zucchini and MacDonald, 2009, Section 6.2).
}
}
\examples{
# m is a moveHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

plotPR(m)

}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}

