% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_aeqd_crs.R
\name{mt_aeqd_crs}
\alias{mt_aeqd_crs}
\title{Create a AEQD coordinate reference system}
\usage{
mt_aeqd_crs(x, center = c("centroid", "center"), units = c("m", "km"))
}
\arguments{
\item{x}{An object of the class \code{sf} or \code{sfc}, for example a \code{move2} to determine the center from. This argument
is only required if \code{center} is a character.}

\item{center}{Either the method to identify the coordinates of the center of \code{x} or the center as a \code{numeric},
\code{POINT} or a \code{sf}/\code{sfc} of length 1. \code{"centroid"} calculates the centroid of a collection of points while \code{"center"}
calculates the center from the range of the locations.}

\item{units}{The units of the AEQD projection either \code{m} or \code{km} for meter or kilometer respectively}
}
\value{
An object of the class \code{crs} that can for example be used for re projecting
}
\description{
The CRS can be centered around the centroid or center of a \code{move2} object or a reference location
}
\examples{
mt_aeqd_crs(center = c(10, 45))
mt_aeqd_crs(center = sf::st_point(c(10, 45)), units = "km")
m <- mt_read(mt_example())
mt_aeqd_crs(center = sf::st_geometry(m)[5])
mt_aeqd_crs(m)
aeqd_crs <- mt_aeqd_crs(m, "center", "km")
aeqd_crs
sf::st_transform(m, aeqd_crs)
}
