% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mutDoubleGeom}
\alias{mutDoubleGeom}
\alias{mutDoubleGeomScaled}
\title{Double Geometric Distribution Mutator}
\usage{
mutDoubleGeom(ind, p = 1, geomp = 0.9, lower, upper)

mutDoubleGeomScaled(ind, p = 1, sdev = 0.05, lower, upper)
}
\arguments{
\item{ind}{\verb{[integer]} individual to mutate.}

\item{p}{\verb{[numeric(1)]} per-entry probability to perform mutation.}

\item{geomp}{\verb{[numeric]} geometric distribution parameter.}

\item{lower}{\verb{[integer]} lower bounds of \code{ind} values. May have same length as
\code{ind} or may be a single number, if the lower bounds are the same for all
values.}

\item{upper}{\verb{[integer]} upper bounds of \code{ind} values. May have same length as
\code{ind} or may be a single number, if the upper bounds are the same for all
values.}

\item{sdev}{\verb{[numeric]} standard deviation, relative to \code{upper - lower}.}
}
\value{
\verb{[integer]}
}
\description{
"Double Geometric" mutation operator for integer parameters: with
probability \code{p} a random geometrically distributed value is added,
and another (different) one subtracted.

\code{mutDoubleGeomScaled} scales \code{sdev} with each component's range and then uses
\code{geomp = (sqrt(2 * sdev^2 + 1) - 1) / sdev^2}.
}
\seealso{
Other operators: 
\code{\link{mutGaussIntScaled}()},
\code{\link{mutGaussInt}()},
\code{\link{mutGaussScaled}()},
\code{\link{mutPolynomialInt}()},
\code{\link{mutRandomChoice}()},
\code{\link{mutUniformInt}()},
\code{\link{recGaussian}()},
\code{\link{recIntIntermediate}()},
\code{\link{recIntSBX}()}
}
\concept{operators}
