% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mutRandomChoice}
\alias{mutRandomChoice}
\title{Random Choice Mutator}
\usage{
mutRandomChoice(ind, values, p = 0.1)
}
\arguments{
\item{ind}{\verb{[character]} individual to mutate.}

\item{values}{\verb{[list of character]} set of possible values for \code{ind} entries to take.
May be a list of length 1, in which case it is recycled.}

\item{p}{\verb{[numeric(1)]} per-entry probability to perform mutation.}
}
\value{
\verb{[character]}
}
\description{
"Random Choice" mutation operator for discrete parameters: with probability
\code{p} chooses one of the available categories at random (this \emph{may} be
the original value!)
}
\seealso{
Other operators: 
\code{\link{mutDoubleGeom}()},
\code{\link{mutGaussIntScaled}()},
\code{\link{mutGaussInt}()},
\code{\link{mutGaussScaled}()},
\code{\link{mutPolynomialInt}()},
\code{\link{mutUniformInt}()},
\code{\link{recGaussian}()},
\code{\link{recIntIntermediate}()},
\code{\link{recIntSBX}()}
}
\concept{operators}
