% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme.mosaic}
\alias{theme.mosaic}
\alias{col.mosaic}
\title{Lattice Theme}
\usage{
theme.mosaic(bw = FALSE, lty = if (bw) 1:7 else 1, lwd = 2, ...)

col.mosaic(bw = FALSE, lty = if (bw) 1:7 else 1, lwd = 2, ...)
}
\arguments{
\item{bw}{whether color scheme should be "black and white"}

\item{lty}{vector of line type codes}

\item{lwd}{vector of line widths}

\item{...}{additional named arguments passed to
\code{\link[=trellis.par.set]{trellis.par.set()}}}
}
\value{
Returns a list that can be supplied as the \code{theme} to
\code{\link[=trellis.par.set]{trellis.par.set()}}.
}
\description{
A theme for use with lattice graphics.
}
\note{
These two functions are identical.  \code{col.mosaic} is named
similarly to \code{\link[lattice:standard.theme]{lattice::col.whitebg()}}, but since more
than just colors are set, \code{theme.mosaic} is a preferable name.
}
\examples{
trellis.par.set(theme=theme.mosaic())
show.settings()
trellis.par.set(theme=theme.mosaic(bw=TRUE))
show.settings()

}
\seealso{
\code{\link[=trellis.par.set]{trellis.par.set()}}, \code{\link[=show.settings]{show.settings()}}
}
\keyword{graphics}
