% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeo.R
\name{leaflet_map}
\alias{leaflet_map}
\title{Simple Leaflet Maps}
\usage{
leaflet_map(latitude = NULL, longitude = NULL, position = NULL,
  zoom = 12, mark = FALSE, radius = 0, units = c("km", "miles",
  "meters", "feet"), ...)
}
\arguments{
\item{latitude, longitude}{vectors of latitude and longitude values.
If \code{latitude} is a data frame, then it is treated as \code{position}.
This facilitates "piping" from \code{\link[=rgeo]{rgeo()}}.  See examples.}

\item{position}{a data frame containing latitude and longitude positions}

\item{zoom}{zoom level for initial map (1-20)}

\item{mark}{a logical indicating whether the location should be marked with a pin}

\item{radius}{a vector of radii of circles (in miles) centered at position that are displayed on the map}

\item{units}{units for radii of circles (km, miles, meters, or feet).}

\item{\dots}{additional arguments passed to \code{\link[leaflet:addCircles]{leaflet::addCircles()}}}
}
\value{
a leaflet map
}
\description{
Primarily designed to work with \code{\link[=rgeo]{rgeo()}} to display randomly sampled
points on the globe.
}
\examples{
  # Times Square
  leaflet_map(40.7566, -73.9863, radius = 1, units = "miles")  
  # 3 random locations; 5 km circles
  leaflet_map(position = rgeo(3), radius = 5, mark = TRUE, color = "red") 
  # using pipes
  rgeo(4, latlim = c(25,50), lonlim = c(-65, -125)) \%>\%
    leaflet_map(radius = 5, mark = TRUE, color = "purple")
}
\seealso{
\code{\link[=deg2rad]{deg2rad()}}, \code{\link[=latlon2xyz]{latlon2xyz()}} and \code{\link[=rgeo]{rgeo()}}.
}
