% Generated by roxygen2 (4.0.2): do not edit by hand
\name{factorize}
\alias{factorize}
\alias{factorize.character}
\alias{factorize.data.frame}
\alias{factorize.default}
\alias{factorize.numeric}
\title{Conditionally convert vectors to factors}
\usage{
factorize(x, ...)

\method{factorize}{default}(x, ...)

\method{factorize}{numeric}(x, max.levels = 5L, ...)

\method{factorize}{character}(x, max.levels = 5L, ...)

\method{factorize}{data.frame}(x, max.levels = 5L, ...)
}
\arguments{
\item{x}{an object}

\item{...}{additional arguments (currently ignored)}

\item{max.levels}{an integer.  Only convert if the number of unique values is no
more than \code{max.levels}.}
}
\description{
A generic function and several instances for creating factors from
other sorts of data.  The primary use case is for vectors that contain
few unique values and might be better considered as factors.  When
applied to a data frame, this is applied to each variable in the data frame.
}
\examples{
data(KidsFeet, package="mosaicData")
str(KidsFeet)
factorize(KidsFeet$birthyear)
str(factorize(KidsFeet))
}

