% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.survFitTKTD.R
\name{print.survFitTKTD}
\alias{print.survFitTKTD}
\title{Print of \code{survFitTKTD} object}
\usage{
\method{print}{survFitTKTD}(x, ...)
}
\arguments{
\item{x}{An object of class \code{survFitTKTD}}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
print the model text and the Jags Computing information
}
\description{
This is the generic \code{print} S3 method for the \code{survFitTKTD} class.
It prints the underlying JAGS model and some information on the Bayesian 
inference procedure.
}
\examples{
# (1) Load the data
data(propiconazole)

# (2) Create an object of class 'survData'
dat <- survData(propiconazole)

\donttest{
# (3) Run the survFitTKTD function
out <- survFitTKTD(dat, quiet = TRUE)

# (4) Print the survFitTKTD object
print(out)
}

}
\keyword{print}
