% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.survDataCstExp.R
\name{plot.survDataCstExp}
\alias{plot.survDataCstExp}
\title{Plotting method for \code{survData} objects}
\usage{
\method{plot}{survDataCstExp}(
  x,
  xlab = "Time",
  ylab = "Number of survivors",
  main = NULL,
  concentration = NULL,
  style = "ggplot",
  pool.replicate = FALSE,
  addlegend = FALSE,
  remove.someLabels = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{survData}}

\item{xlab}{a label for the \eqn{X}-axis, by default \code{Time}}

\item{ylab}{a label for the \eqn{Y}-axis, by default \code{Number of survivors}}

\item{main}{main title for the plot}

\item{concentration}{a numeric value corresponding to some concentration(s) in
\code{data}. If \code{concentration = NULL}, draws a plot for each concentration}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{pool.replicate}{if \code{TRUE}, the datapoints of each replicate are
summed for a same concentration}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{remove.someLabels}{if \code{TRUE}, removes 3/4 of \eqn{X}-axis labels in
\code{'ggplot'} style to avoid label overlap}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the \code{survData} class.
It plots the number of survivors as a function of time.
}
\note{
When \code{style = "ggplot"} (default), the function calls function
\code{\link[ggplot2]{ggplot}} and returns an object of class \code{ggplot}.
}
\examples{
# (1) Load the data
data(zinc)
zinc <- survData(zinc)

# (2) Plot survival data with a ggplot style
plot(zinc)

# (3) Plot the survival data for one specific concentration
plot(zinc, concentration = 0.66)

}
\keyword{plot}
