% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceSummary.R
\name{varianceSummary}
\alias{varianceSummary}
\title{Summary of the variance analysis results.}
\usage{
varianceSummary(..., component = 1L, drawBoxplot = TRUE, regions = c(6L,
  6L), addWorld = TRUE, outline = FALSE, parMap = list(mar = c(0, 0, 0,
  0)), parGraph = list(mar = c(2.5, 2.5, 3, 1)))
}
\arguments{
\item{...}{A single or multiple objects returned by function \code{\link[mopa]{varianceAnalysis}}.}

\item{component}{Integer indicating the number of the component analyzed in function 
\code{\link[mopa]{varianceAnalysis}}. Choices are 1 (Component1), 2 (Component2) or 3 (Component12).}

\item{drawBoxplot}{Logical. If FALSE, points of the spatial mean are plotted.}

\item{regions}{Either a \code{SpatialPolygons} object (see \code{\link[sp]{SpatialPolygons}}) or integer
of length 2 indicating the number of chunks in which to divide longitudes and latitudes.}

\item{addWorld}{Logical that indicates if the lines of the world should be drawn on the map.}

\item{outline}{Same as in \code{\link[graphics]{boxplot}}.}

\item{parMap}{List of graphical parameters affecting the output map.}

\item{parGraph}{List of graphical parameters affecting the output boxplot/pointplot.}
}
\value{
This function returns a map of the spatial subset performed and a graph of the variance 
 results for each spatial subset.  Additionally, returns a matrix (or list of matrixes) with the 
 summary of the results.
}
\description{
Illustrates the results of the variance analysis performed with 
function \code{\link[mopa]{varianceAnalysis}} based on a spatial subsetting of the 
study area.
}
\details{
When parameter 'regions' is an integer (not a \code{SpatialPolygons} object) a grid 
of polygons is created using function \code{\link[raster]{union}}
from package \pkg{raster}. 

Boxes/points of the total standard deviation in each region is are also plotted (over 100)
with colored background.

The output boxplot shows the spatial spread of the results in each region. On the contrary, if paramter
\code{drawBoxplot = FALSE}, the output graph only shows points of the spatial mean for each region.
However, might be useful when multiple results are compared, as the resulting graph has a cleaner 
appearance.
}
\examples{
## Load climate data
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

## Fitted models
data(mods)
?mods

## Model prediction and analysis of the variability in projections
newClim <- lapply(1:4, function(x){
crop(biostack$future[[x]], extent(-10, 5, 35, 60))
})

prdRS.fut <- mopaPredict(models = mods, newClim = newClim)
result <- varianceAnalysis(prdRS.fut, "PA", "newClim")
\donttest{
## Summary of the results
varianceSummary(result, component = 2, regions = c(4, 6))

## Use a SpatialPolygons object for spatial subsetting

destfile <- tempfile()
data.url <- "https://github.com/SantanderMetGroup/visualizeR/raw/devel/data/PRUDENCEregions.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)
varianceSummary("mars" = result, component = 2, regions = PRUDENCEregions)
}
}
\seealso{
\code{\link[mopa]{varianceAnalysis}}
}
\author{
M. Iturbide
}
