% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_CUM_BINNING.R
\name{cum.bin}
\alias{cum.bin}
\title{Monotonic binning based on maximum cumulative target rate (MAPA)}
\usage{
cum.bin(
  x,
  y,
  sc = c(NA, NaN, Inf),
  sc.method = "together",
  g = 15,
  y.type = NA,
  force.trend = NA
)
}
\arguments{
\item{x}{Numeric vector to be binned.}

\item{y}{Numeric target vector (binary or continuous).}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf)}.
Recommendation is to keep the default values always and add new ones if needed. Otherwise, if these values exist
in \code{x} and are not defined in the \code{sc} vector, function will report the error.}

\item{sc.method}{Define how special cases will be treated, all together or in separate bins.
Possible values are \code{"together", "separately"}.}

\item{g}{Number of starting groups. Default is 15.}

\item{y.type}{Type of \code{y}, possible options are \code{"bina"} (binary) and  \code{"cont"} (continuous).
If default value (\code{NA}) is passed, then algorithm will identify if \code{y} is 0/1 or continuous variable.}

\item{force.trend}{If the expected trend should be forced. Possible values: \code{"i"} for
increasing trend (\code{y} increases with increase of \code{x}), \code{"d"} for decreasing trend
(\code{y} decreases with decrease of \code{x}). Default value is \code{NA}.
If the default value is passed, then trend will be identified based on the sign of the Spearman correlation
coefficient between \code{x} and \code{y} on complete cases.}
}
\value{
The command \code{cum.bin} generates a list of two objects. The first object, data frame \code{summary.tbl}
presents a summary table of final binning, while \code{x.trans} is a vector of discretized values.
In case of single unique value for \code{x} or \code{y} in complete cases (cases different than special cases),
it will return data frame with info.
}
\description{
\code{cum.bin} implements monotonic binning based on maximum cumulative target rate.
This algorithm is known as MAPA (Monotone Adjacent Pooling Algorithm).
}
\examples{
suppressMessages(library(monobin))
data(gcd)
amount.bin <- cum.bin(x = gcd$amount, y = gcd$qual)
amount.bin[[1]]
gcd$amount.bin <- amount.bin[[2]]
gcd \%>\% group_by(amount.bin) \%>\% summarise(n = n(), y.avg = mean(qual))
#increase default number of groups (g = 20)
amount.bin.1 <- cum.bin(x = gcd$amount, y = gcd$qual, g = 20)
amount.bin.1[[1]]
#force trend to decreasing
cum.bin(x = gcd$amount, y = gcd$qual, g = 20, force.trend = "d")[[1]]

}
