% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mono_utils.R
\name{new_node}
\alias{new_node}
\title{Create A New Node for Split Data Frame}
\usage{
new_node(
  number,
  var,
  cut = -99L,
  n,
  inertia,
  bipartsplitrow = -99L,
  bipartsplitcol = -99L,
  inertiadel = 0,
  inertia_explained = -99,
  medoid,
  loc,
  split.order = -99L,
  alt = list(tibble::tibble(bipartsplitrow = numeric(), bipartsplitcol = numeric()))
)
}
\arguments{
\item{number}{Row index of the data frame.}

\item{var}{Whether it is a leaf, or the name of the next split variable.}

\item{cut}{The splitting value, so values (of \code{var}) smaller than that
go to left branch while values greater than that go to right branch.}

\item{n}{Cluster size. Number of observations in that cluster.}

\item{inertia}{Inertia value of the cluster at that node.}

\item{bipartsplitrow}{Position of the next split row in the data set (that
position will belong to left node (smaller)).}

\item{bipartsplitcol}{Position of the next split variable in the data set.}

\item{inertiadel}{The proportion of inertia value of the cluster at that node
to the inertia of the root.}

\item{inertia_explained}{Percent inertia explained as described in Chavent
(2007)}

\item{medoid}{Position of the data point regarded as the medoid of its
cluster.}

\item{loc}{y-coordinate of the splitting node to facilitate showing on the
tree. See \code{\link[=plot.MonoClust]{plot.MonoClust()}} for details.}

\item{split.order}{Order of the splits. Root is 0, and increasing.}

\item{alt}{Indicator of an alternative cut yielding the same reduction in
inertia at that split.}
}
\value{
A tibble with only one row and correct default data type for even an
unspecified variables.
}
\description{
This function is just a helper to make sure that the default values of the
split data frame is correct when unspecified. It helps reduce type error,
especially when moving to use dplyr which is stricter in data types.
}
\references{
\itemize{
\item Chavent, M., Lechevallier, Y., & Briant, O. (2007). DIVCLUS-T: A monothetic
divisive hierarchical clustering method. Computational Statistics & Data
Analysis, 52(2), 687–701. https://doi.org/10.1016/j.csda.2007.03.013
}
}
\keyword{internal}
