languageFromExtension <- function(ext){
  switch(tolower(ext),
         abap = "abap",
         bash = "shell",
         bat = "bat",
         c = "c",
         "c++" = "cpp",
         clj = "clojure",
         cls = "apex",
         cmd = "bat",
         coffee = "coffeescript",
         cp = "cpp",
         cpp = "cpp",
         cs = "csharp",
         css = "css",
         dockerfile = "dockerfile",
         fs = "fsharp",
         graphql = "graphql",
         h = "c",
         handlebars = "handlebars",
         hbs = "handlebars",
         hpp = "cpp",
         html = "html",
         ini = "ini",
         jade = "pug",
         java = "java",
         jl = "julia",
         js = "javascript",
         json = "json",
         jsx = "javascript",
         kt = "kotlin",
         less = "less",
         lua = "lua",
         m = "objective-c",
         md = "markdown",
         mysql = "mysql",
         pas = "pascal",
         perl = "perl",
         pgsql = "pgsql",
         php = "php",
         pl = "perl",
         ps1 = "powershell",
         pug = "pug",
         py = "python",
         r = "r",
         razor = "razor",
         rhtml = "html",
         rmd = "markdown",
         rest = "restructuredtext",
         rs = "rust",
         rst = "restructuredtext",
         ru = "ruby",
         scala = "scala",
         scm = "scheme",
         scss = "scss",
         sh = "shell",
         sql = "sql",
         swift = "swift",
         tcl = "tcl",
         ts = "typescript",
         twig = "twig",
         txt = "plaintext",
         vb = "vb",
         xml = "xml",
         yaml = "yaml",
         yml = "yaml"
  )
}

extensionFromLanguage <- function(language){
  switch(
    language,
    abap = "abap",
    bat = "bat",
    c = "c",
    cpp = "c++",
    clojure = "clj",
    apex = "cls",
    coffeescript = "coffee",
    csharp = "cs",
    css = "css",
    dockerfile = "dockerfile",
    fsharp = "fs",
    graphql = "graphql",
    handlebars = "handlebars",
    html = "html",
    ini = "ini",
    java = "java",
    julia = "jl",
    javascript = "js",
    json = "json",
    kotlin = "kt",
    less = "less",
    lua = "lua",
    `objective-c` = "m",
    markdown = "md",
    mysql = "mysql",
    pascal = "pas",
    pgsql = "pgsql",
    php = "php",
    perl = "pl",
    powershell = "ps1",
    pug = "pug",
    python = "py",
    r = "r",
    razor = "razor",
    rust = "rs",
    restructuredtext = "rst",
    ruby = "ru",
    scala = "scala",
    scheme = "scm",
    scss = "scss",
    shell = "sh",
    sql = "sql",
    swift = "swift",
    tcl = "tcl",
    typescript = "ts",
    twig = "twig",
    plaintext = "txt",
    vb = "vb",
    xml = "xml",
    yaml = "yaml"
  )
}

#' @importFrom rstudioapi hasFun readRStudioPreference
#' @noRd
getTabSize <- function(){
  if(hasFun("readRStudioPreference")){
    readRStudioPreference("num_spaces_for_tab", 2)
  }else{
    2
  }
}

binaryExtensions <- c(
  "3dm",
  "3ds",
  "3g2",
  "3gp",
  "7z",
  "a",
  "aac",
  "adp",
  "ai",
  "aif",
  "aiff",
  "alz",
  "ape",
  "apk",
  "appimage",
  "ar",
  "arj",
  "asf",
  "au",
  "avi",
  "bak",
  "baml",
  "bh",
  "bin",
  "bk",
  "bmp",
  "btif",
  "bz2",
  "bzip2",
  "cab",
  "caf",
  "cgm",
  "class",
  "cmx",
  "cpio",
  "cr2",
  "cur",
  "dat",
  "dcm",
  "deb",
  "dex",
  "djvu",
  "dll",
  "dmg",
  "dng",
  "doc",
  "docm",
  "docx",
  "dot",
  "dotm",
  "dra",
  "DS_Store",
  "dsk",
  "dts",
  "dtshd",
  "dvb",
  "dwg",
  "dxf",
  "ecelp4800",
  "ecelp7470",
  "ecelp9600",
  "egg",
  "eol",
  "eot",
  "epub",
  "exe",
  "f4v",
  "fbs",
  "fh",
  "fla",
  "flac",
  "flatpak",
  "fli",
  "flv",
  "fpx",
  "fst",
  "fvt",
  "g3",
  "gh",
  "gif",
  "graffle",
  "gz",
  "gzip",
  "h261",
  "h263",
  "h264",
  "icns",
  "ico",
  "ief",
  "img",
  "ipa",
  "iso",
  "jar",
  "jpeg",
  "jpg",
  "jpgv",
  "jpm",
  "jxr",
  "key",
  "ktx",
  "lha",
  "lib",
  "lvp",
  "lz",
  "lzh",
  "lzma",
  "lzo",
  "m3u",
  "m4a",
  "m4v",
  "mar",
  "mdi",
  "mht",
  "mid",
  "midi",
  "mj2",
  "mka",
  "mkv",
  "mmr",
  "mng",
  "mobi",
  "mov",
  "movie",
  "mp3",
  "mp4",
  "mp4a",
  "mpeg",
  "mpg",
  "mpga",
  "mxu",
  "nef",
  "npx",
  "numbers",
  "nupkg",
  "o",
  "oga",
  "ogg",
  "ogv",
  "otf",
  "pages",
  "pbm",
  "pcx",
  "pdb",
  "pdf",
  "pea",
  "pgm",
  "pic",
  "png",
  "pnm",
  "pot",
  "potm",
  "potx",
  "ppa",
  "ppam",
  "ppm",
  "pps",
  "ppsm",
  "ppsx",
  "ppt",
  "pptm",
  "pptx",
  "psd",
  "pya",
  "pyc",
  "pyo",
  "pyv",
  "qt",
  "rar",
  "ras",
  "raw",
  "resources",
  "rgb",
  "rip",
  "rlc",
  "rmf",
  "rmvb",
  "rpm",
  "rtf",
  "rz",
  "s3m",
  "s7z",
  "scpt",
  "sgi",
  "shar",
  "snap",
  "sil",
  "sketch",
  "slk",
  "smv",
  "snk",
  "so",
  "stl",
  "suo",
  "sub",
  "swf",
  "tar",
  "tbz",
  "tbz2",
  "tga",
  "tgz",
  "thmx",
  "tif",
  "tiff",
  "tlz",
  "ttc",
  "ttf",
  "txz",
  "udf",
  "uvh",
  "uvi",
  "uvm",
  "uvp",
  "uvs",
  "uvu",
  "viv",
  "vob",
  "war",
  "wav",
  "wax",
  "wbmp",
  "wdp",
  "weba",
  "webm",
  "webp",
  "whl",
  "wim",
  "wm",
  "wma",
  "wmv",
  "wmx",
  "woff",
  "woff2",
  "wrm",
  "wvx",
  "xbm",
  "xif",
  "xla",
  "xlam",
  "xls",
  "xlsb",
  "xlsm",
  "xlsx",
  "xlt",
  "xltm",
  "xltx",
  "xm",
  "xmind",
  "xpi",
  "xpm",
  "xwd",
  "xz",
  "z",
  "zip",
  "zipx"
)

#' @importFrom htmltools tags
#' @noRd
tinyCheckbox <- function(ID, id, label){
  tags$div(id = ID,
           class = "check-box-container",
           style = "display: none;",
           tags$input(id = id, type = "checkbox",
                      class = "check-box-input",
                      checked = ""),
           tags$label(`for` = id, class = "check-box",
                      style = "margin-right: 0;"),
           tags$label(`for` = id,
                      tags$span(style = "color: whitesmoke;", label),
                      class = "check-box-label")
  )
}

randomString <- function(size){
  paste0(
    sample(c(letters, LETTERS, 0:9), size, replace = TRUE),
    collapse = ""
  )
}
