% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{interaction_score}
\alias{interaction_score}
\title{Computes interaction score for combined graphs}
\usage{
interaction_score(graphs, drug_target_edgelists, settings)
}
\arguments{
\item{graphs}{A named list (elements `group1` and `group2`). Each element contains the combined
graph for its group.}

\item{drug_target_edgelists}{A named list (elements `group1` and `group2`). Each element
contains the list of edges adjacent to drug targets as a data frame (columns `from`, `to` and
`weight`)}

\item{settings}{A named list containing pipeline settings}
}
\value{
A named list (elements `group1` and `group2`). Each element contains an iGraph object
 containing the interaction score as weight.
}
\description{
Writes the input data (combined graphs for both groups in gml format and
lists of edges adjacent to drug targets for both groups) to files and calls
a python script for calculating the score.
Output files written by the python script are two graphs in gml format containing the
interaction score as weight.
These are loaded and returned in a named list.
ATTENTION: Data exchange via files is mandatory and takes a long for large data. Interaction
score computation is expensive and slow because it involves finding all
simple paths up to a certain length between source and target node of the
drug target edges. Don't set `max_path_length` in settings to a large value and only consider
this step if your graphs have up to approximately 2 million edges.
Computation is initiated by \code{\link{calculate_interaction_score}}. The
python script is parallelized using Ray. Use the setting `int_score_mode` to
force sequential or parallel computation. Refer to the Ray documentation
if you encounter problems with running the python script in parallel.
DISCLAIMER: Depending on the operating system Python comes pre-installed or has to be installed
 manually.
Please pay attention to the version and the executable used (python/python3 or homebrew
python). You can use the `python_executable` setting to specify the command or path.
}
\examples{
data(combined_graphs_example)
data(drug_targets_example)
settings <- molnet_settings()
\donttest{
interaction_score_graphs <- interaction_score(combined_graphs_example[["graphs"]],
drug_target_edgelists=drug_targets_example[["edgelist"]],
settings=settings)
}

}
