% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPCr.R
\name{OPCr}
\alias{OPCr}
\title{Calculate average orientation patch count after several rotations}
\usage{
OPCr(plyFile, steps = 8, stepSize = 5.625, minimum_faces = 3, minimum_area = 0)
}
\arguments{
\item{plyFile}{An object of classes 'mesh3d' and 'shape3d' with
calculated normals}

\item{steps}{Number of iterations to run the \code{OPC()} function on
the mesh}

\item{stepSize}{Amount of rotation (in degrees) about the Z-axis
to adjust mesh surface by between each iteration of \code{OPC()}}

\item{minimum_faces}{Argument to pass to the \code{OPC()} function}

\item{minimum_area}{Argument to pass to the \code{OPC()} function}
}
\description{
A function that calls OPC iteratively after rotating mesh a selected
number of degrees around the Z-axis following Evans and Jernvall
(2009) Patterns and constraints in carnivoran and rodent dental
complexity and tooth size. J Vert Paleo 29:24A
}
\details{
The function requires a mesh object created by reading in a ply file utilizing
either the, \code{\link[Rvcg]{vcgPlyRead}} function.

Default number of steps is 8, with a stepSize of 5.625 degrees, following the
original published definition of OPCR.

See the details for the \code{\link{OPC}} function for more information about
preparing mesh surfaces and the effects of \code{minimum_faces} and \code{minimum_area}.
}
