% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoezipf.R
\name{smoezipf}
\alias{smoezipf}
\title{Survival function.}
\usage{
smoezipf(x, alpha, beta, show.plot = F)
}
\arguments{
\item{x}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{show.plot}{logical; if TRUE shows the plot of the distibution (default = FALSE).}
}
\value{
The survival probability value associated to each component in vector \code{x}.
}
\description{
Survival function for the MOEZipf with parameters \eqn{\alpha}, \eqn{\beta}.
}
\details{
The survival function at value x is computed as follows:
\deqn{S(x) = \frac{\beta \zeta(\alpha, x + 1)}{\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x + 1)}}
}
\examples{
smoezipf(1:10, 2.5, 1.3)
smoezipf(1:10, 2.5, 1.3, show.plot = TRUE)
}

