% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorize_output.R
\name{set_modsem_colors}
\alias{set_modsem_colors}
\title{Define or disable the color theme used by \code{modsem}}
\usage{
set_modsem_colors(
  positive = "green3",
  negative = positive,
  true = "green3",
  false = "red",
  nan = "purple",
  na = "purple",
  inf = "purple",
  string = "cyan",
  active = TRUE
)
}
\arguments{
\item{positive}{color of positive numbers.}

\item{negative}{color of negative numbers.}

\item{true}{color of \code{TRUE}.}

\item{false}{color of \code{FALSE}.}

\item{nan}{color of \code{NaN}.}

\item{na}{color of \code{NA}.}

\item{inf}{color of \code{-Inf} and \code{Inf}.}

\item{string}{color of quoted strings.}

\item{active}{Should color-theme be activated/deactived?}
}
\value{
\code{TRUE} if colors are active afterwards, otherwise \code{FALSE}.
}
\description{
All arguments are optional; omitted ones fall back to the defaults below.
Pass \code{active = FALSE} to turn highlighting off (and reset the palette).
}
\examples{
set_modsem_colors(positive = "red3", 
                  negative = "red3",
                  true = "darkgreen", 
                  false = "red3", 
                  na = "purple",
                  string = "darkgreen")

m1 <- "
# Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3
# Inner Model
  Y ~ X + Z + X:Z
"

est <- modsem(m1, data = oneInt)
colorize_output(summary(est))
colorize_output(est) # same as colorize_output(print(est))
colorize_output(modsem_inspect(est, what = "coef"))

\dontrun{
colorize_output(split = TRUE, {
  # Get live (uncolored) output
  # And print colored output at the end of execution

  est_lms <- modsem(m1, data = oneInt, method = "lms")
  summary(est_lms)
}) 
                
colorize_output(modsem_inspect(est_lms))
}
}
