% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{add_model}
\alias{add_model}
\title{Add predictive models to Summary list.}
\usage{
add_model(addTo, x, y, model = NULL, tuneLength = 5L, modelTag = NULL,
  tf = NULL, sampling = NULL)
}
\arguments{
\item{addTo}{Summary list that will contain all model fit results.}

\item{x}{A dataframe of input variables.}

\item{y}{A vector or a dataframe of output variable.}

\item{model}{A vector of model names to train.}

\item{tuneLength}{the maximum number of tuning parameter combinations
that will be generated by the random search}

\item{modelTag}{A charactor value of tag that to be added to model name.}

\item{tf}{A single charactor value for transformation options. tf1, tf2, and tf3.
For details, see the suggest_transformation function.}

\item{sampling}{A single character value to pass caret::trainControl.
Values are "none", "down", "up", "smote", or "rose". The latter two values require
the DMwR and ROSE packages, respectively.}
}
\value{
If input model and data supports classification, then the results of
each model fittings are added to the summary list.
}
\description{
\code{add_model} Conduct model training and add each model fit to a summary list.
The function ensures that the model and data supports classification.
If model supports class probability, then the best model is choosen based on
AUC. If model doesnt support class probabilities, the best model is
choosen based on accuracy. We use 10-fold cross validation by default.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]

sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")

# vignette("modeval") #check a vignette for further details
}
}
