% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRC.R
\name{LRC}
\alias{LRC}
\title{Tool to computate the Long-Run Cost Rate for a Continuous Time Markov Chain, CTMC.}
\usage{
LRC(X, costs)
}
\arguments{
\item{X}{matrix, represents the rate matrix of a CTMC.}

\item{costs}{vector, represents the costs of the states of a CTMC.}
}
\description{
\code{LRC} is used to obtain the Long-Run Cost Rate of a homogeneous continuous time Markov chain.
}
\examples{
\dontrun{library(modesto)
R <- matrix(c(0,1,0,0,0, 1/72,0,1,0,0, 0,2/72,0,1,0, 0,0,3/72,0,1/2, 0,0,0,4/72,0),5,5,byrow=TRUE)
LRC(X=R,costs=c(-80,-15,50,125,200)) # A five states CTMC example}
}
\references{
Ross, S, Introduction to Probability Models, Eleven Edition. Academic Press, 2014.

Kulkarni V, Introduction to modeling and analysis of stochastic systems. Second Edition. Springer-Verlag, 2011.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
