% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate.mediation.R
\name{modmed}
\alias{modmed}
\title{Causal Moderated Mediation Analysis}
\usage{
modmed(
  data,
  treatment,
  mediator,
  outcome,
  covariates.disc = NULL,
  covariates.cont = NULL,
  moderators.disc = NULL,
  moderators.cont = NULL,
  m.model,
  y.model,
  comp.treatment.value = 1,
  ref.treatment.value = 0,
  comp.mod.disc.values = NULL,
  ref.mod.disc.values = NULL,
  comp.mod.cont.values = NULL,
  ref.mod.cont.values = NULL,
  m.scale = "continuous",
  y.scale = "continuous",
  method = "mc",
  nmc = 1000,
  nboot = 1000,
  conf.level = 0.95,
  seed = NULL,
  object = NULL,
  is.U = FALSE,
  sens.effect = NULL,
  b.m = NULL,
  b.y = NULL,
  plot.effect = NULL
)
}
\arguments{
\item{data}{A data frame containing the variables in the analysis. Users need to impute any missing values in the data before running the function.}

\item{treatment}{A character string indicating the name of the treatment variable.}

\item{mediator}{A character string indicating the name of the mediator variable.}

\item{outcome}{A character string indicating the name of the outcome variable.}

\item{covariates.disc}{A name vector of the discrete pretreatment covariates that are not moderators (string). The default is NULL. Users do not need to reformat discrete variables. If treatment is randomized, it should contain confounders of the mediator-outcome relationship. If treatment is not randomized, it should also contain confounders of the treatment-mediator and treatment-outcome relationships. Please do not include moderators here. The main effects of moderators are accounted for by including the moderators in the model of the main model intercept.}

\item{covariates.cont}{A name vector of the continuous pretreatment covariates that are not moderators (string). The default is NULL. If treatment is randomized, it should contain confounders of the mediator-outcome relationship. If treatment is not randomized, it should also contain confounders of the treatment-mediator and treatment-outcome relationships. Please do not include moderators here. The main effects of moderators are accounted for by including the moderators in the model of the main model intercept.}

\item{moderators.disc}{A name vector of all the discrete moderators under study (string). The default is NULL.}

\item{moderators.cont}{A name vector of all the continuous moderators under study (string). The default is NULL.}

\item{m.model}{A list. The name of each element in the list is a predictor in the main mediator model.  The names must include intercept, treatment, covariates.disc, and covariates.cont. Each element of the list is a vector of the names of the moderators (string) of the coefficient of the main model predictor as represented by the name of the element. Each moderator specified in moderators.disc and moderators.cont must moderate at least one slope in either the mediator model or the outcome model. The moderators of the intercept must include all the moderators in the mediator model. If a main model coefficient is not moderated, then the corresponding vector should be specified as NULL. The set of moderators in m.model and that in y.model are not necessarily the same. In other words, for a moderator that moderates coefficient(s) in one model, it is possible that it does not occur in the other model. It is also possible that it only has its main effect in the other model, in which case it will be only included in the vector of the intercept in the list of the other model. The union of the two sets of moderators should be contained in the union of moderators.disc, and moderators.cont. If no moderators are specified, only the population average mediation effects are estimated and tested. Check examples for details.}

\item{y.model}{A list. The name of each element in the list is a predictor in the main outcome model. The names must include intercept, treatment, mediator, covariates.disc, and covariates.cont. If the treatment is assumed to interact with the mediator when affecting the outcome, an additional element should be added to y.model, named as "tm". Each element of the list is a vector of the names of the moderators (string) of the coefficient of the main model predictor as represented by the name of the element. Each moderator specified in moderators.disc and moderators.cont must moderate at least one slope in either the main mediator model or the main outcome model. The moderators of the intercept must include all the moderators in the mediator model. If a main model coefficient is not moderated, then the corresponding vector should be specified as NULL. The set of moderators in m.model and that in y.model are not necessarily the same. In other words, for a moderator that moderates coefficient(s) in one model, it is possible that it does not occur in the other model. It is also possible that it only has its main effect in the other model, in which case it will be only included in the vector of the intercept in the list of the other model. The union of the two sets of moderators should be contained in the union of moderators.disc, and moderators.cont. If no moderators are specified, only the population average mediation effects are estimated and tested. Check examples for details.}

\item{comp.treatment.value}{If the total treatment effect for each individual is defined as Y(t) - Y(t'), comp.treatment.value refers to t. The default is 1.}

\item{ref.treatment.value}{If the total treatment effect for each individual is defined as Y(t) - Y(t'), ref.treatment.value refers to t'. The default is 0.}

\item{comp.mod.disc.values}{A vector of compare values of the discrete moderators given which the conditional causal effects are estimated. The default is NULL.  The length and order of comp.mod.disc.values should be the same as moderators.disc. If one does not want to condition some moderators on specific values, one may specify their values to be NA. If the discrete moderators take the same compare value, comp.moderator.disc.values can be specified as a single value. If not NULL, results contrasting the causal effects given compare moderator values with those given reference moderator values will be reported.}

\item{ref.mod.disc.values}{A vector of reference values of the discrete moderators given which the conditional causal effects are estimated. The default is NULL. The length and order of ref.mod.disc.values should be the same as moderators.disc. If one does not want to condition some moderators on specific values, one may specify their values to be NA. If the discrete moderators take the same reference value, ref.moderator.disc.values can be specified as a single value. The moderators whose reference values are specified must be included in either the mediator model or the outcome model or both.}

\item{comp.mod.cont.values}{A vector of compare values of the continuous moderators given which the conditional causal effects are estimated. The default is NULL. The length and order of comp.mod.cont.values should be the same as moderators.cont. If one does not want to condition some moderators on specific values, one may specify their values to be NA. If the continuous moderators take the same compare value, comp.moderator.cont.values can be specified as a single value. If not NULL, results contrasting the causal effects given compare moderator values with those given reference moderator values will be reported.}

\item{ref.mod.cont.values}{A vector of reference values of the continuous moderators given which the conditional causal effects are estimated. The default is NULL. The length and order of ref.mod.cont.values should be the same as moderators.cont. If one does not want to condition some moderators on specific values, one may specify their values to be NA. If the continuous moderators take the same reference value, ref.moderator.cont.values can be specified as a single value. The moderators whose reference values are specified must be included in either the mediator model or the outcome model or both.}

\item{m.scale}{A character string indicating the scale of the mediator. "continuous" if the mediator is continuous. "binary" if the mediator is binary. Logistic regression is fitted in this case. The default is "continuous".}

\item{y.scale}{A character string indicating the scale of the outcome. "continuous" if the outcome is continuous. "binary" if the outcome is binary. Probit link is used in this case. The default is "continuous".}

\item{method}{Estimation and inference method. if 'mc', the Monte Carlo method is used; if 'boot', bootstrap is used. Default is 'mc'. When sample size is relatively small and the mediator or binary is binary, 'boot' is preferred. Otherwise, 'mc' is more recommended, mainly because its running speed is much faster.}

\item{nmc}{Number of simulations involved in the Monte Carlo algorithm. Used if method = 'mc'. The default value is 1000.}

\item{nboot}{Number of bootstrapped samples involved in the bootstrapping algorithm. Used if method = 'boot'. The default value is 1000.}

\item{conf.level}{Level of the returned two-sided confidence intervals. The default is 0.95, which returns the 2.5 and 97.5 percentiles.}

\item{seed}{The seed for the random number generator. The default value is NULL.}

\item{object}{Output from the original analysis only if is.U = TRUE. NULL in the original analysis. The default is NULL.}

\item{is.U}{A logical value. 'FALSE' in the original analysis. 'TRUE' in the sensitivity analysis which adjusts for a simulated unmeasured pretreatment confounder U. The default is FALSE.}

\item{sens.effect}{The default is NULL. It is used only when modmed.sens is run.}

\item{b.m}{Sensitivity parameter that represents the conditional association between the unobserved pretreatment confounder and the mediator. It is NULL in the original analysis. The default is NULL. It is used only when modmed.sens is run.}

\item{b.y}{Sensitivity parameter that represents the conditional association between the unobserved pretreatment confounder and the outcome. It is NULL in the original analysis. The default is NULL. It is used only when modmed.sens is run.}

\item{plot.effect}{The effect to be plotted. The default is NULL. It is used only when modmed.plot is run.}
}
\value{
A list containing
\item{effects}{Estimation results of the causal effects. "TE" indicates the total treatment effect. "TIE" indicates the total indirect effect, "PDE" indicates the pure direct effect, and "INT" indicates the natural treatment-by-mediator interaction effect. "TE.ref", "TIE.ref", "PDE.ref", and "INT.ref" indicate the corresponding effects when the moderators take the reference values. "TE.dif", TIE.dif", "PDE.dif", and "INT.dif" each indicates the difference in the corresponding effect between the compare levels and the reference levels of the moderators.}
\item{m.model}{Estimation results of the mediator model}
\item{y.model}{Estimation results of the outcome model}
\item{results}{1000 draws from the sampling distribution of the causal effects.}
\item{args}{A list of the arguments specified in the function of modmed except for the default ones}
\item{args.full}{The full list of all the arugments specified in the function of modmed}
\item{l.m}{The mediator model}
\item{l.y}{The outcome model}
\item{formula.m}{The formula for the mediator model}
\item{formula.y}{The formula for the outcome model}
\item{m.predictors}{All the original predictors in the main mediator model}
\item{y.predictors}{All the original predictors in the main outcome model}
\item{m.moderators}{All the original moderators in the mediator model}
\item{y.moderators}{All the original moderators in the outcome model}
\item{m.predictors.new}{All the predictors in the main mediator model, in which the discrete confounders are transformed into multiple indicator codes.}
\item{y.predictors.new}{All the predictors in the main outcome model, in which the discrete confounders are transformed into multiple indicator codes.}
\item{m.moderators.new}{All the moderators in the mediator model, in which the discrete confounders are transformed into multiple indicator codes.}
\item{y.moderators.new}{All the moderators in the outcome model, in which the discrete confounders are transformed into multiple indicator codes.}
\item{predict.m.data.ref}{Data for prediction of the conditional potential mediator at the reference level of the moderators.}
\item{predict.m.data.comp}{Data for prediction of the conditional potential mediator at the compare level of the moderators.}
\item{predict.m.data}{Data for prediction of the marginal potential mediator}
\item{predict.y.data.ref}{Data for prediction of the conditional potential outcome at the reference level of the moderators.}
\item{predict.y.data.comp}{Data for prediction of the conditional potential outcome at the compare level of the moderators.}
\item{predict.y.data}{Data for prediction of the marginal potential outcome}
\item{data}{The data used in the analysis}
}
\description{
'modmed' is used to fit mediator and outcome models and estimate and test causal effects for causal moderated mediation analysis. It is applicable to a treatment of any scale, a binary or continuous mediator and outcome, one or more moderators of any scale, and a wide range of scenarios of moderated mediation.
}
\examples{
data(newws)
modmed.results = modmed(data = newws, treatment = "treat",
    mediator = "emp", outcome = "depression", covariates.disc = NULL,
    covariates.cont = NULL, moderators.disc = "CHCNT", moderators.cont = NULL,
    m.model = list(intercept = "CHCNT", treatment = "CHCNT"),
    y.model = list(intercept = "CHCNT", treatment = "CHCNT",
        mediator = "CHCNT", tm = "CHCNT"), comp.mod.disc.values = 3,
    ref.mod.disc.values = 2, comp.mod.cont.values = NULL, ref.mod.cont.values = NULL,
    m.scale = "binary", y.scale = "continuous", seed = 1)
\donttest{
modmed.results = modmed(data = newws, treatment = "treat",
    mediator = "emp", outcome = "depression", covariates.disc = c("emp_prior",
        "nevmar", "hispanic", "nohsdip"), covariates.cont = c("workpref",
        "attitude", "depress_prior"), moderators.disc = "CHCNT",
    moderators.cont = "ADCPC", m.model = list(intercept = c("ADCPC",
        "CHCNT"), treatment = c("ADCPC", "CHCNT"), emp_prior = NULL,
        nevmar = NULL, hispanic = NULL, nohsdip = NULL,
        workpref = NULL, attitude = NULL, depress_prior = NULL),
    y.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), mediator = c("ADCPC", "CHCNT"), tm = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL,
        depress_prior = NULL), comp.mod.disc.values = 3,
    ref.mod.disc.values = 2, comp.mod.cont.values = 5050,
    ref.mod.cont.values = 5050, m.scale = "binary", y.scale = "continuous",
    seed = 1)
}
}
\references{
Qin, X., & Wang, L. (2022). Causal Moderated Mediation Analysis.
}
\author{
Xu Qin and Lijuan Wang
}
