% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{permute}
\alias{permute}
\alias{permute_}
\title{Generate \code{n} permutation replicates.}
\usage{
permute(data, n, ..., .id = ".id")

permute_(data, n, columns, .id = ".id")
}
\arguments{
\item{data}{A data frame}

\item{n}{Number of permutations to generate.}

\item{...}{Columns to permute. This supports bare column names or dplyr
\link[dplyr:reexports]{dplyr::select_helpers}}

\item{.id}{Name of variable that gives each model a unique integer id.}

\item{columns}{In \code{permute_}, vector of column names to permute.}
}
\value{
A data frame with \code{n} rows and one column: \code{perm}
}
\description{
A permutation test involves permuting one or more variables in a data set
before performing the test, in order to break any existing relationships
and simulate the null hypothesis. One can then compare the true statistic
to the generated distribution of null statistics.
}
\examples{

library(purrr)
perms <- permute(mtcars,  1000, mpg)

models <- map(perms$perm, ~ lm(mpg ~ wt, data = .))
glanced <- map_df(models, broom::glance, .id = "id")

# distribution of null permutation statistics
hist(glanced$statistic)
# confirm these are roughly uniform p-values
hist(glanced$p.value)

# test against the unpermuted model to get a permutation p-value
mod <- lm(mpg ~ wt, mtcars)
mean(glanced$statistic > broom::glance(mod)$statistic)

}
