% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataprepmodelplots.R
\name{aggregate_over_ntiles}
\alias{aggregate_over_ntiles}
\title{Build a dataframe with aggregated evaluation measures}
\usage{
aggregate_over_ntiles(prepared_input)
}
\arguments{
\item{prepared_input}{Dataframe resulting from function \code{\link{prepare_scores_and_ntiles}} or a data frame that meets
requirements as specified in the section below: \bold{When you build input for aggregate_over_ntiles() yourself} .}
}
\value{
Dataframe object is returned, containing:
\tabular{lll}{
  \bold{column} \tab \bold{type} \tab \bold{definition} \cr
  model_label \tab String \tab Name of the model object \cr
  dataset_label \tab Factor \tab Datasets to include in the plot as factor levels\cr
  target_class\tab String or Integer\tab Target classes to include in the plot\cr
  ntile\tab Integer\tab Ntile groups based on model probability for target class\cr
  neg\tab Integer\tab Number of cases not belonging to target class in dataset in ntile\cr
  pos\tab Integer\tab Number of cases belonging to target class in dataset in ntile\cr
  tot\tab Integer\tab Total number of cases in dataset in ntile\cr
  pct\tab Decimal \tab Percentage of cases in dataset in ntile that belongs to
    target class (pos/tot)\cr
  negtot\tab Integer\tab Total number of cases not belonging to target class in dataset\cr
  postot\tab Integer\tab Total number of cases belonging to target class in dataset\cr
  tottot\tab Integer\tab Total number of cases in dataset\cr
  pcttot\tab Decimal\tab Percentage of cases in dataset that belongs to
    target class (postot / tottot)\cr
  cumneg\tab Integer\tab Cumulative number of cases not belonging to target class in
    dataset from ntile 1 up until ntile\cr
  cumpos\tab Integer\tab Cumulative number of cases belonging to target class in
    dataset from ntile 1 up until ntile\cr
  cumtot\tab Integer\tab Cumulative number of cases in dataset from ntile 1
    up until ntile\cr
  cumpct\tab Integer\tab Cumulative percentage of cases belonging to target class in
    dataset from ntile 1 up until ntile (cumpos/cumtot)\cr
  gain\tab Decimal\tab Gains value for dataset for ntile (pos/postot)\cr
  cumgain\tab Decimal\tab Cumulative gains value for dataset for ntile
    (cumpos/postot)\cr
  gain_ref\tab Decimal\tab Lower reference for gains value for dataset for ntile
    (ntile/#ntiles)\cr
  gain_opt\tab Decimal\tab Upper reference for gains value for dataset for ntile\cr
  lift\tab Decimal\tab Lift value for dataset for ntile (pct/pcttot)\cr
  cumlift\tab Decimal\tab Cumulative lift value for dataset for ntile
    ((cumpos/cumtot)/pcttot)\cr
  cumlift_ref\tab Decimal\tab Reference value for Cumulative lift value (constant: 1)
 }
}
\description{
Build a dataframe with aggregated actuals and predictions.
Records in this dataframe represent the unique combinations of models [m], datasets [d], targetvalues [t] and ntiles [n].
The size of this dataframe therefore is (m*d*t*n) rows and 23 columns. \cr\cr \bold{\emph{In most cases, you do not need to use function
  since the \code{\link{plotting_scope}} function will call this function automatically.}}
}
\section{When you build input for aggregate_over_ntiles() yourself}{

To make plots with modelplotr, is not required to use the function prepare_scores_and_ntiles to generate the required input data.
You can create your own dataframe containing actuals and probabilities and ntiles (1st ntile = (1/#ntiles) percent
with highest model probability, last ntile = (1/#ntiles) percent with lowest probability according to model) ,
In that case, make sure the input dataframe contains the folowing columns & formats:
\tabular{lll}{
  \bold{column} \tab \bold{type} \tab \bold{definition} \cr
  model_label \tab Factor \tab Name of the model object \cr
  dataset_label \tab Factor \tab Datasets to include in the plot as factor levels\cr
  y_true \tab Factor \tab Target with actual values \cr
  prob_[tv1] \tab Decimal \tab Probability according to model for target value 1 \cr
  prob_[tv2] \tab Decimal \tab Probability according to model for target value 2 \cr
  ... \tab ... \tab ... \cr
  prob_[tvn] \tab Decimal \tab Probability according to model for target value n \cr
  ntl_[tv1] \tab Integer \tab Ntile based on probability according to model for target value 1 \cr
  ntl_[tv2] \tab Integerl \tab Ntile based on probability according to model for target value 2 \cr
  ... \tab ... \tab ... \cr
  ntl_[tvn] \tab Integer \tab Ntile based on probability according to model for target value n
 }
See \code{\link{build_input_yourself}} for an example to build the required input yourself.
}

\examples{
\dontrun{
# load example data (Bank clients with/without a term deposit - see ?bank_td for details)
data("bank_td")

# prepare data for training model for binomial target has_td and train models
train_index =  sample(seq(1, nrow(bank_td)),size = 0.5*nrow(bank_td) ,replace = FALSE)
train = bank_td[train_index,c('has_td','duration','campaign','pdays','previous','euribor3m')]
test = bank_td[-train_index,c('has_td','duration','campaign','pdays','previous','euribor3m')]

#train models using mlr...
trainTask <- mlr::makeClassifTask(data = train, target = "has_td")
testTask <- mlr::makeClassifTask(data = test, target = "has_td")
mlr::configureMlr() # this line is needed when using mlr without loading it (mlr::)
task = mlr::makeClassifTask(data = train, target = "has_td")
lrn = mlr::makeLearner("classif.randomForest", predict.type = "prob")
rf = mlr::train(lrn, task)
lrn = mlr::makeLearner("classif.multinom", predict.type = "prob")
mnl = mlr::train(lrn, task)
#... or train models using caret...
# setting caret cross validation, here tuned for speed (not accuracy!)
fitControl <- caret::trainControl(method = "cv",number = 2,classProbs=TRUE)
# random forest using ranger package, here tuned for speed (not accuracy!)
rf = caret::train(has_td ~.,data = train, method = "ranger",trControl = fitControl,
                  tuneGrid = expand.grid(.mtry = 2,.splitrule = "gini",.min.node.size=10))
# mnl model using glmnet package
mnl = caret::train(has_td ~.,data = train, method = "glmnet",trControl = fitControl)
#... or train models using h2o...
h2o::h2o.init()
h2o::h2o.no_progress()
h2o_train = h2o::as.h2o(train)
h2o_test = h2o::as.h2o(test)
gbm <- h2o::h2o.gbm(y = "has_td",
                          x = setdiff(colnames(train), "has_td"),
                          training_frame = h2o_train,
                          nfolds = 5)
#... or train models using keras.
x_train <- as.matrix(train[,-1]); y=train[,1]; y_train <- keras::to_categorical(as.numeric(y)-1);
`\%>\%` <- magrittr::`\%>\%`
nn <- keras::keras_model_sequential() \%>\%
keras::layer_dense(units = 16,kernel_initializer = "uniform",activation = 'relu',
                   input_shape = NCOL(x_train))\%>\%
  keras::layer_dense(units = 16,kernel_initializer = "uniform", activation='relu') \%>\%
  keras::layer_dense(units = length(levels(train[,1])),activation='softmax')
nn \%>\% keras::compile(optimizer='rmsprop',loss='categorical_crossentropy',metrics=c('accuracy'))
nn \%>\% keras::fit(x_train,y_train,epochs = 20,batch_size = 1028,verbose=0)

# preparation steps
scores_and_ntiles <- prepare_scores_and_ntiles(datasets=list("train","test"),
                      dataset_labels = list("train data","test data"),
                      models = list("rf","mnl", "gbm","nn"),
                      model_labels = list("random forest","multinomial logit",
                                          "gradient boosting machine","artificial neural network"),
                      target_column="has_td")
aggregated <- aggregate_over_ntiles(prepared_input=scores_and_ntiles)
head(aggregated)
plot_input <- plotting_scope(prepared_input = aggregated)
head(plot_input)
}
}
\seealso{
\code{\link{modelplotr}} for generic info on the package \code{moddelplotr}

\code{vignette('modelplotr')}

\code{\link{prepare_scores_and_ntiles}} for details on the function \code{prepare_scores_and_ntiles}
that generates the required input.

\code{\link{plotting_scope}} for details on the function \code{plotting_scope} that
filters the output of \code{aggregate_over_ntiles} to prepare it for the required evaluation.

\code{\link{build_input_yourself}} for an example to build the required input yourself.

\url{https://github.com/modelplot/modelplotr} for details on the package

\url{https://modelplot.github.io/} for our blog on the value of the model plots
}
