#' Chicago taxi data set
#'
#' @description
#'
#' A data set containing information on a subset of taxi trips in the city
#' of Chicago in 2022.
#'
#' @name taxi
#' @aliases taxi
#' @docType data
#'
#' @return tibble
#'
#' @details
#'
#' The source data are originally described on the linked City of Chicago
#' data portal. The data exported here are a pre-processed subset motivated by
#' the modeling problem of predicting whether a rider will tip or not.
#'
#' \describe{
#'   \item{tip}{Whether the rider left a tip. A factor with levels
#'     "yes" and "no".}
#'   \item{distance}{The trip distance, in odometer miles.}
#'   \item{company}{The taxi company, as a factor. Companies that occurred
#'     few times were binned as "other".}
#'   \item{local}{Whether the trip started in the same community
#'     area as it began. See the source data for community area values.}
#'   \item{dow}{The day of the week in which the trip began, as a
#'     factor.}
#'   \item{month}{The month in which the trip began, as a factor.}
#'   \item{hour}{The hour of the day in which the trip began, as a
#'     numeric.}
#' }
#'
#' @source
#'
#' \url{https://data.cityofchicago.org/Transportation/Taxi-Trips/wrvz-psew}
#'
#' @examples
#' \donttest{
#' taxi
#' }
NULL
