set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

rfout <-
  mobforest.analysis(
    as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls =
      mobforest.control(ntree = 3, mtry = 2, replace = T, alpha = 0.05,
                        bonferroni = T, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)

# Run Tests
test_that("get.varimp was successful in all calculations.", {
  # Crim Variable
  expect_equal(unname(round(get.varimp(rfout)[1], 4)), 2.64)
  # Tax Variable
  expect_equal(unname(round(get.varimp(rfout)[3], 4)), -3.5508)
})
