% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghget.R
\name{ghget}
\alias{ghget}
\title{ghget}
\usage{
ghget(..., .force = FALSE, .tempdir = TRUE)
}
\arguments{
\item{...}{parameters to set and activate a repository}

\item{.force}{logical: download and unzip in any case? (default: \code{FALSE})}

\item{.tempdir}{logical or character: store download temporary or permanently (default: \code{getOption("mmstat4.tempdir")})
\itemize{
\item if \code{.tempdir==TRUE} then the downloaded zip file will be stored temporarily in \code{\link[=tempdir]{tempdir()}}
\item if \code{.tempdir==FALSE} then the downloaded zip file will be stored temporarily in \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
\item otherwise it is assumed that you give the name of an existing directory to store the downloaded zip file
}}
}
\value{
invisibly the name of the current key
}
\description{
Makes a repository the active repository and downloads it if necessary.
If the function is run interactively then you are asked if you want to store the repository in the application directory
\code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}} for \code{mmstat4} or in the temporary directory \code{\link[=tempdir]{tempdir()}}. Otherwise the stored directory
path is used (usually \code{\link[=tempdir]{tempdir()}}).
}
\details{
Note, the list of repository names, directories and urls is stored in the installation directory, too.
}
\examples{
if (interactive()) {
  # get one of the default ZIP file from internet
  ghget("hu.data")
  # get a locally stored zip file
  ghget(dummy2=system.file("zip", "mmstat4.dummy.zip", package="mmstat4"))
  # get from an URL
  ghget(dummy.url="https://github.com/sigbertklinke/mmstat4.dummy/archive/refs/heads/main.zip")
}
}
