% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{process_replication_study}
\alias{process_replication_study}
\title{Process Replication Study Data}
\usage{
process_replication_study(replication_data, original_study_results)
}
\arguments{
\item{replication_data}{A data frame containing the replication study data,
with columns \code{ColLabs} for labels and \code{ColVals} for values.}

\item{original_study_results}{A list containing the results of an original study,
including the hypothesis and pairwise t-test results, if applicable.}
}
\value{
A list containing the results from the Bayesian analysis (\code{bain_results})
and a message indicating if the null hypothesis and the original hypothesis were
the same (\code{message}).
}
\description{
This function processes the data from a replication study by comparing it
with the results from an original study, using the \code{bain} package for Bayesian
inference.
}
\details{
The function begins by extracting the original hypothesis (\code{Horiginal}) from
the \code{original_study_results}. It then generates the null hypothesis (\code{Ho})
using the \code{generate_Ho_from_pairwise_t} function.

A hypothesis string for the Bayesian analysis is prepared by comparing \code{Ho}
and \code{Horiginal}. If they are the same, only \code{Horiginal} is used; otherwise,
both are included in the Bayesian analysis via \code{bain}.

An ANOVA model is fitted to the replication data, which is then passed to
the \code{bain} function along with the hypothesis string. The Bayesian analysis
results are returned along with any message regarding the comparison of
hypotheses.
}
\examples{
replication_results <- process_replication_study(
  replication_data = generate_study_data(
    x = deal_cards_to_rc_grid(n = 3),
    sample_size = 30
  ),
  original_study_results = process_original_study(
    df = generate_study_data(
      x = deal_cards_to_rc_grid(n = 3),
      sample_size = 30
    ),
    alpha = 0.05
  )
)

}
