% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmiCATs.R
\name{mmiCATs}
\alias{mmiCATs}
\title{Set Up CATs Analysis in Shiny Application}
\usage{
mmiCATs()
}
\value{
A Shiny app object which can be run to start the application.
}
\description{
This function creates a Shiny application for performing CATs (Cluster-Adjusted
t-statistics) analysis. It provides a user interface for uploading a CSV file,
specifying the model and additional arguments, and running the analysis. The
output includes variable selection, GLM (Generalized Linear Model) summary,
and results of the CATs analysis.
}
\details{
The application allows the user to upload a dataset, specify a GLM model and
additional arguments, and run CATs analysis. The UI consists of various input
elements like file upload, text input, numeric input, and action buttons. The
server part handles the data processing, model fitting, and execution of the
CATs analysis. The application outputs include the list of variables,
GLM model summary, and the results from the CATs analysis.
}
\examples{
# To run the Shiny app
if(interactive()){
  mmiCATs()
}

}
\references{
Esarey J, Menger A. Practical and Effective Approaches to Dealing With Clustered
Data. Political Science Research and Methods. 2019;7(3):541-559.
doi:10.1017/psrm.2017.42
}
