% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traceplot_asgn.R
\name{traceplot_asgn}
\alias{traceplot_asgn}
\title{Create Traceplots for MCMC Parameters}
\usage{
traceplot_asgn(mcmc_samples, param = "all", main = NULL)
}
\arguments{
\item{mcmc_samples}{List containing MCMC samples for alpha, mu, and sigma2}

\item{param}{Parameter to plot: "alpha", "mu", "sigma2", or "all" (default: "all")}

\item{main}{Main title for the plot (optional)}
}
\value{
No return value, creates base R plots
}
\description{
Creates traceplots for MCMC parameters (alpha, mu, sigma2) to assess convergence.
Users are responsible for setting up their preferred plot layout using par().
}
\examples{
\donttest{
# Load the datasets
data(cancer_demo)
data(normal_demo)
rst <- mmcmcBayes(cancer_demo, normal_demo, 
                 stage = 1,max_stages = 2,num_splits = 5,
                 test = "BF", priors_cancer = NULL, priors_normal = NULL,
                 bf_thresholds = list(stage1 = 10, stage2 = 10.3, stage3 = 10.3),
                 return_mcmc = TRUE)

traceplot_asgn(rst$mcmc_samples$current_stage$cancer, param = "alpha", main = "Cancer Alpha")
}
}
