% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mlxplore.R
\name{mlxplore}
\alias{mlxplore}
\title{Explore and visualize models}
\usage{
mlxplore(model, parameter = NULL, output = NULL, group = NULL,
  treatment = NULL)
}
\arguments{
\item{model}{a \code{Mlxtran} or \code{PharmML} model}

\item{parameter}{a vector of parameters with their names and values}

\item{output}{a list with fields:
\itemize{
  \item \code{name}: a vector of output names
  \item \code{time}: a vector of times
}}

\item{group}{a list with unique field:
\itemize{
  \item \code{treatment} : a list,
}}

\item{treatment}{a list with fields
\itemize{
  \item \code{time} : a vector of input times,
  \item \code{amount} : a scalar or a vector of amounts,
  \item \code{rate} : a scalar or a vector of infusion rates (default=\code{Inf}),
  \item \code{type} : the type of input (default=1),
  \item \code{target} : the target compartment (default=NULL).
}}
}
\description{
Explore and visualize \samp{Mlxtran} and \samp{pharmML} models
with the \samp{Mlxplore} software.
}
\details{
See http://simulx.webpopix.org/mlxr/mlxplore/ for more details.
}

