% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerDesignPoints.R
\name{mlr_tuners_design_points}
\alias{mlr_tuners_design_points}
\alias{TunerDesignPoints}
\title{Hyperparameter Tuning with via Design Points}
\description{
Subclass for tuning w.r.t. fixed design points.

We simply search over a set of points fully specified by the user. The points
in the design are evaluated in order as given.
}
\section{Dictionary}{

This \link{Tuner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_tuners} or with the associated sugar function \code{\link[=tnr]{tnr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{TunerDesignPoints$new()
mlr_tuners$get("design_points")
tnr("design_points")
}\if{html}{\out{</div>}}
}

\section{Parallelization}{

In order to support general termination criteria and parallelization, we
evaluate points in a batch-fashion of size \code{batch_size}. Larger batches mean
we can parallelize more, smaller batches imply a more fine-grained checking
of termination criteria. A batch contains of \code{batch_size} times \code{resampling$iters} jobs.
E.g., if you set a batch size of 10 points and do a 5-fold cross validation, you can
utilize up to 50 cores.

Parallelization is supported via package \CRANpkg{future} (see \code{\link[mlr3:benchmark]{mlr3::benchmark()}}'s
section on parallelization for more details).
}

\section{Logging}{

All \link{Tuner}s use a logger (as implemented in \CRANpkg{lgr}) from package
\CRANpkg{bbotk}.
Use \code{lgr::get_logger("bbotk")} to access and control the logger.
}

\section{Optimizer}{

This \link{Tuner} is based on \link[bbotk:mlr_optimizers_design_points]{bbotk::OptimizerDesignPoints} which can be applied on any black box optimization problem.
See also the documentation of \href{https://bbotk.mlr-org.com/}{bbotk}.
}

\section{Parameters}{


\describe{
\item{\code{batch_size}}{\code{integer(1)}\cr
Maximum number of configurations to try in a batch.}
\item{\code{design}}{\link[data.table:data.table]{data.table::data.table}\cr
Design points to try in search, one per row.}
}

}

\section{Progress Bars}{


\verb{$optimize()} supports progress bars via the package \href{https://CRAN.R-project.org/package=progressr}{\pkg{progressr}}
combined with a \link[bbotk]{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\href{https://CRAN.R-project.org/package=progress}{\pkg{progress}} as backend; enable with \code{progressr::handlers("progress")}.

}

\examples{
library(data.table)

# retrieve task
task = tsk("pima")

# load learner and set search space
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

# hyperparameter tuning on the pima indians diabetes data set
instance = tune(
  method = "design_points",
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  design = data.table(cp = c(log(1e-1), log(1e-2)))
)

# best performing hyperparameter configuration
instance$result

# all evaluated hyperparameter configuration
as.data.table(instance$archive)

# fit final model on complete data set
learner$param_set$values = instance$result_learner_param_vals
learner$train(task)
}
\seealso{
Package \CRANpkg{mlr3hyperband} for hyperband tuning.

Other Tuner: 
\code{\link{mlr_tuners_cmaes}},
\code{\link{mlr_tuners_gensa}},
\code{\link{mlr_tuners_grid_search}},
\code{\link{mlr_tuners_irace}},
\code{\link{mlr_tuners_nloptr}},
\code{\link{mlr_tuners_random_search}},
\code{\link{mlr_tuners}}
}
\concept{Tuner}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerFromOptimizer]{mlr3tuning::TunerFromOptimizer}} -> \code{TunerDesignPoints}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerDesignPoints-new}{\code{TunerDesignPoints$new()}}
\item \href{#method-TunerDesignPoints-clone}{\code{TunerDesignPoints$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerFromOptimizer" data-id="optimize"><a href='../../mlr3tuning/html/TunerFromOptimizer.html#method-TunerFromOptimizer-optimize'><code>mlr3tuning::TunerFromOptimizer$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerDesignPoints-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerDesignPoints-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerDesignPoints$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerDesignPoints-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerDesignPoints-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerDesignPoints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
