% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerDesignPoints.R
\docType{data}
\name{TunerDesignPoints}
\alias{TunerDesignPoints}
\alias{mlr_tuners_design_points}
\title{TunerDesignPoints}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Tuner}.}
\description{
Subclass for tuning w.r.t. fixed design points.

We simply search over a set of points fully specified by the user.
The points in the design are evaluated in order as given.

In order to support general termination criteria and parallelization,
we evaluate points in a batch-fashion of size \code{batch_size}.
Larger batches mean we can parallelize more, smaller batches imply a more fine-grained checking
of termination criteria.
}
\section{Construction}{
\preformatted{TunerDesignPoints$new()
tnr("design_points")
}
}

\section{Parameters}{

\itemize{
\item \code{batch_size} :: \code{integer(1)}\cr
Maximum number of configurations to try in a batch.
}
}

\examples{
# see ?Tuner
}
\seealso{
Other Tuner: \code{\link{TunerGenSA}},
  \code{\link{TunerGridSearch}},
  \code{\link{TunerRandomSearch}}, \code{\link{Tuner}},
  \code{\link{mlr_tuners}}
}
\concept{Tuner}
\keyword{datasets}
