% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ResamplingSpCVKnndm}
\alias{autoplot.ResamplingSpCVKnndm}
\alias{autoplot.ResamplingRepeatedSpCVKnndm}
\alias{plot.ResamplingSpCVKnndm}
\alias{plot.ResamplingRepeatedSpCVKnndm}
\title{Visualization Functions for SpCV knndm Method.}
\usage{
\method{autoplot}{ResamplingSpCVKnndm}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  repeats_id = NULL,
  sample_fold_n = NULL,
  ...
)

\method{autoplot}{ResamplingRepeatedSpCVKnndm}(
  object,
  task,
  fold_id = NULL,
  repeats_id = 1,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  sample_fold_n = NULL,
  ...
)

\method{plot}{ResamplingSpCVKnndm}(x, ...)

\method{plot}{ResamplingRepeatedSpCVKnndm}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVBlock} or
\link{ResamplingRepeatedSpCVBlock}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{sample_fold_n}{\verb{[integer]}\cr
Number of points in a random sample stratified over partitions.
This argument aims to keep file sizes of resulting plots reasonable and
reduce overplotting in dense datasets.}

\item{...}{Passed to \code{geom_sf()}. Helpful for adjusting point sizes and
shapes.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object. One of class \link{ResamplingSpCVBuffer},
\link{ResamplingSpCVBlock}, \link{ResamplingSpCVCoords}, \link{ResamplingSpCVEnv}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods to
visualize mlr3 spatiotemporal resampling objects.
}
\details{
This method requires to set argument \code{fold_id} and no plot containing all
partitions can be created. This is because the method does not make use of
all observations but only a subset of them (many observations are left out).
Hence, train and test sets of one fold are not re-used in other folds as in
other methods and plotting these without a train/test indicator would not
make sense.
}
\section{2D vs 3D plotting}{

This method has both a 2D and a 3D plotting method.
The 2D method returns a \pkg{ggplot} with x and y axes representing the spatial
coordinates.
The 3D method uses \pkg{plotly} to create an interactive 3D plot.
Set \code{plot3D = TRUE} to use the 3D method.

Note that spatiotemporal datasets usually suffer from overplotting in 2D
mode.
}

\examples{
\donttest{
if (mlr3misc::require_namespaces(c("CAST", "sf"), quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task = tsk("ecuador")
  points = sf::st_as_sf(task$coordinates(), crs = task$crs, coords = c("x", "y"))
  modeldomain = sf::st_as_sfc(sf::st_bbox(points))

  resampling = rsmp("spcv_knndm",
    folds = 5, modeldomain = modeldomain)
  resampling$instantiate(task)

  autoplot(resampling, task,
    fold_id = 1, size = 0.7) *
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on \href{https://mlr3book.mlr-org.com/chapters/chapter13/beyond_regression_and_classification.html#spatiotemp-cv}{"Spatiotemporal Visualization"}
\item Vignette \href{https://mlr3spatiotempcv.mlr-org.com/articles/spatiotemp-viz.html}{Spatiotemporal Visualization}.
\item \code{\link[=autoplot.ResamplingSpCVBlock]{autoplot.ResamplingSpCVBlock()}}
\item \code{\link[=autoplot.ResamplingSpCVBuffer]{autoplot.ResamplingSpCVBuffer()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVTiles]{autoplot.ResamplingSpCVTiles()}}
\item \code{\link[=autoplot.ResamplingSpCVEnv]{autoplot.ResamplingSpCVEnv()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
}
}
