% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvGlmnet.R
\name{LearnerSurvGlmnet}
\alias{LearnerSurvGlmnet}
\alias{mlr_learners_surv.glmnet}
\title{GLM with Elastic Net Regularization Survival Learner}
\description{
Calls \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.
\itemize{
\item lp is predicted by \code{\link[glmnet:predict.glmnet]{glmnet::predict.glmnet()}}
\item \code{crank} is identical to \code{lp}
}

Use \link{LearnerSurvGlmnet} and \link{LearnerSurvCVGlmnet} for glmnets without and with internal
cross-validation, respectively. Tuning using the internal optimizer in \link{LearnerSurvCVGlmnet}
may be more efficient when tuning lambda only. However, for tuning multiple hyperparameters,
\CRANpkg{mlr3tuning} and \link{LearnerSurvGlmnet} will likely give better results.

Parameter \code{s} (value of the regularization parameter used for predictions) is set to the median
of the \code{lambda} sequence by default, but needs to be tuned by the user.
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:lrn]{lrn()}:\preformatted{LearnerSurvGlmnet$new()
mlr_learners$get("surv.glmnet")
lrn("surv.glmnet")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, lp}
\item Feature Types: \verb{integer, numeric, factor}
\item Properties: \code{weights}
\item Packages: \CRANpkg{glmnet} \CRANpkg{survival}
}
}

\references{
\cite{mlr3proba}{friedman_2010}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvXgboost}}
}
\concept{survival learners}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerSurv]{mlr3proba::LearnerSurv}} -> \code{LearnerSurvGlmnet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerSurvGlmnet$new()}}
\item \href{#method-clone}{\code{LearnerSurvGlmnet$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvGlmnet$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvGlmnet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
