% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CnfClause.R
\name{CnfClause}
\alias{CnfClause}
\alias{as.CnfClause}
\title{Clauses in CNF Formulas}
\usage{
CnfClause(atoms)

as.CnfClause(x)
}
\arguments{
\item{atoms}{(\code{list} of (\code{\link{CnfAtom}} | \code{CnfClause})) \cr
A list of \code{\link{CnfAtom}} or other \code{CnfClause} objects.
The clause represents the disjunction of these atoms.}

\item{x}{(any) \cr
The object to be coerced to a \code{CnfClause} by \code{as.CnfClause}.
Only \code{logical(1)}, \code{\link{CnfAtom}}, and \code{CnfClause} itself are currently supported.}
}
\value{
A new \code{CnfClause} object.
}
\description{
A \code{CnfClause} is a disjunction of \code{\link{CnfAtom}} objects. It represents a statement
that is true if at least one of the atoms is true. These are for example of the form

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  X \%among\% c("a", "b", "c") | Y \%among\% c("d", "e", "f") | ...
}\if{html}{\out{</div>}}

\code{CnfClause} objects can be constructed explicitly, using the \code{CnfClause()} constructor,
or implicitly, by using the \code{|} operator on \code{\link{CnfAtom}}s or other \code{CnfClause} objects.

\code{CnfClause} objects which are not tautologies or contradictions are named lists;
the value ranges of each symbol can be accessed using \code{[[}, and these clauses
can be subset using \code{[} to get clauses containing only the indicated symbols.
However, to get a list of \code{\link{CnfAtom}} objects, use \code{as.list()}.
Note that the simplified form of a clause containing a contradiction is the empty list.

Upon construction, the \code{CnfClause} is simplified by (1) removing contradictions, (2) unifying
atoms that refer to the same symbol, and (3) evaluating to \code{TRUE} if any atom is \code{TRUE}.
Note that the order of atoms in a clause is not preserved.

Using \code{CnfClause()} on lists that contain other \code{CnfClause} objects will create
a clause that is the disjunction of all atoms in all clauses.

If a \code{CnfClause} contains no atoms, or only \code{FALSE} atoms, it evaluates to \code{FALSE}.
If it contains at least one atom that is always true, the clause evaluates to \code{TRUE}.
These values can be converted to, and from, \code{logical(1)} values using \code{as.logical()}
and \code{as.CnfClause()}.

\code{CnfClause} objects can be negated using the \code{!} operator, and combined using the
\code{&} operator. Both of these operations return a \code{\link{CnfFormula}}, even if the result
could in principle be represented as a single \code{CnfClause}.

This is part of the CNF representation tooling, which is currently considered
experimental; it is for internal use.
}
\details{
We are undecided whether it is a better idea to have \code{as.list()} return a named list
or an unnamed one. Calling \code{as.list()} on a \code{CnfClause} with a tautology returns
a tautology-atom, which does not have a name. We currently return a named list
for other clauses, as this makes subsetting by name commute with \code{as.list()}.
However, this behaviour may change in the future.
}
\examples{
u = CnfUniverse()
X = CnfSymbol(u, "X", c("a", "b", "c"))
Y = CnfSymbol(u, "Y", c("d", "e", "f"))

CnfClause(list(X \%among\% c("a", "b"), Y \%among\% c("d", "e")))
cls = X \%among\% c("a", "b") | Y \%among\% c("d", "e")
cls

as.list(cls)

as.CnfClause(X \%among\% c("a", "b"))

# The same symbols are unified
X \%among\% "a" | Y \%among\% "d" | X \%among\% "b"

# tautology evaluates to TRUE
X \%among\% "a" | X \%among\% "b" | X \%among\% "c"

# contradictions are removed
X \%among\% "a" | Y \%among\% character(0)

# create CnfFormula:
!(X \%among\% "a" | Y \%among\% "d")

# also a CnfFormula, even if it contains a single clause:
!CnfClause(list(X \%among\% "a"))
(X \%among\% c("a", "c") | Y \%among\% "d") &
  (X \%among\% c("a", "b") | Y \%among\% "d")
}
\seealso{
Other CNF representation objects: 
\code{\link{CnfAtom}()},
\code{\link{CnfFormula}()},
\code{\link{CnfSymbol}()},
\code{\link{CnfUniverse}()}
}
\concept{CNF representation objects}
\keyword{internal}
