% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gunion.R
\name{gunion}
\alias{gunion}
\title{Disjoint Union of Graphs}
\usage{
gunion(graphs)
}
\arguments{
\item{graphs}{\code{list} of (\code{\link{Graph}} | \code{\link{PipeOp}})\cr
List of elements with one of the types defined above, which are the
\code{\link{Graph}}s to be joined.}
}
\value{
\code{\link{Graph}} the resulting \code{\link{Graph}}.
}
\description{
Takes an arbitrary amount of \code{\link{Graph}}s or \code{\link{PipeOp}}s (or objects that can be automatically
converted into \code{\link{Graph}}s or \code{\link{PipeOp}}s, see \code{\link[=as_graph]{as_graph()}} and \code{\link[=as_pipeop]{as_pipeop()}}) as inputs and joins
them in a new \code{\link{Graph}}.

The \code{\link{PipeOp}}s of the input \code{\link{Graph}}s are not joined with new edges across
\code{\link{Graph}}s, so if \code{length(graphs) > 1} the resulting \code{\link{Graph}} will be disconnected.
}
\seealso{
Other Graph operators: \code{\link{\%>>\%}},
  \code{\link{as_graph}}, \code{\link{as_pipeop}},
  \code{\link{assert_graph}}, \code{\link{assert_pipeop}},
  \code{\link{greplicate}}
}
\concept{Graph operators}
