% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrKM.R
\name{LearnerRegrKM}
\alias{LearnerRegrKM}
\alias{mlr_learners_regr.km}
\title{Kriging Regression Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link[mlr3:LearnerRegr]{mlr3::LearnerRegr}.}
\description{
Kriging regression.
Calls \code{\link[DiceKriging:km]{DiceKriging::km()}} from package \CRANpkg{DiceKriging}.
\itemize{
\item The predict type hyperparameter "type" defaults to "SK" (simple Kriging).
\item The additional hyperparameter \code{nugget.stability} is used to overwrite the hyperparameter \code{nugget} with \code{nugget.stability * var(y)} before training to improve the numerical stability.
We recommend a value of \code{1e-8}.
\item The additional hyperparameter \code{jitter} can be set to add \verb{N(0, [jitter])}-distributed noise to the data before prediction to avoid perfect interpolation. We recommend a value of \code{1e-12}.
}
}
\section{Construction}{
\preformatted{LearnerRegrKM$new()
mlr3::mlr_learners$get("regr.km")
mlr3::lrn("regr.km")
}
}

\examples{
learner = mlr3::lrn("regr.km")
print(learner)

# available parameters:
learner$param_set$ids()
}
\references{
\cite{mlr3learners}{roustant_2012}
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}: \link[mlr3:mlr_learners]{mlr3::mlr_learners}
}
