% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{compute_metrics}
\alias{compute_metrics}
\title{Compute metrics for non-mlr3 predictions.}
\usage{
compute_metrics(data, target, protected_attribute, prediction, metrics = NULL)
}
\arguments{
\item{data}{(\code{data.table}) \cr The dataset used for predicting.}

\item{target}{(\code{character}) \cr The name of the target variable. Must be available in \code{data}.}

\item{protected_attribute}{(\code{character}) \cr The name(s) of the protected attributes(s). Must be available in \code{data}.}

\item{prediction}{(\code{vector}) \cr A vector containing predictions.}

\item{metrics}{(\code{Metric}|\code{list}) \cr (List of) mlr3 metrics to apply.}
}
\description{
Allows computing metrics for predictions that do not stem from mlr3, and were
e.g. being made by models outside of mlr3.
Currently only \code{classif} and \code{regr} - style predictions are supported.
}
\section{Protected Attributes}{

The protected attribute is specified as a \code{col_role} in the corresponding \code{\link[=Task]{Task()}}:\cr
\verb{<Task>$col_roles$pta = "name_of_attribute"} \cr
This also allows specifying more than one protected attribute,
in which case fairness will be considered on the level of intersecting groups defined by all columns
selected as a predicted attribute.
}

\examples{
library("mlr3")
# Get adult data as a data.table
train = tsk("adult_train")$data()
mod = rpart::rpart(target ~ ., train)

# Predict on test data
test = tsk("adult_test")$data()
yhat = predict(mod, test, type = "vector")

# Convert to a factor with the same levels
yhat = as.factor(yhat)
levels(yhat) = levels(test$target)

compute_metrics(
  data = test, 
  target = "target",
  prediction = yhat,
  protected_attribute = "sex",
  metrics = msr("fairness.acc")
)
}
