% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task.R
\name{Task}
\alias{Task}
\title{Task Class}
\description{
This is the abstract base class for \link{TaskSupervised} and \link{TaskUnsupervised}.
\link{TaskClassif} and \link{TaskRegr} inherit from \link{TaskSupervised}.
More supervised tasks are implemented in \CRANpkg{mlr3proba}, unsupervised cluster tasks
in package \CRANpkg{mlr3cluster}.

Tasks serve two purposes:
\enumerate{
\item Tasks wrap a \link{DataBackend}, an object to transparently interface different data storage types.
\item Tasks store meta-information, such as the role of the individual columns in the \link{DataBackend}.
For example, for a classification task a single column must be marked as target column, and others as features.
}

Predefined (toy) tasks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks},
e.g. \code{\link[=mlr_tasks_penguins]{penguins}} or \code{\link[=mlr_tasks_california_housing]{california_housing}}.
More toy tasks can be found in the dictionary after loading \CRANpkg{mlr3data}.
}
\section{S3 methods}{

\itemize{
\item \code{as.data.table(t)}\cr
\link{Task} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns the complete data as \code{\link[data.table:data.table]{data.table::data.table()}}.
\item \code{head(t)}\cr
Calls \code{\link[=head]{head()}} on the task's data.
\item \code{summary(t)}\cr
Calls \code{\link[=summary]{summary()}} on the task's data.
}
}

\section{Task mutators}{

The following methods change the task in-place:
\itemize{
\item Any modification of the lists \verb{$col_roles} or \verb{$row_roles}.
This provides a different "view" on the data without altering the data itself.
This may affects, e.g., \verb{$data}, \verb{$nrow}, \verb{$ncol}, \code{n_features}, \code{row_ids}, and \verb{$feature_names}.
Altering \verb{$col_roles} may affect, e.g., \verb{$data}, \verb{$ncol}, \verb{$n_features}, and \verb{$feature_names}.
Altering \verb{$row_roles} may affect, e.g., \verb{$data}, \verb{$nrow}, and \verb{$row_ids}.
\item Modification of column or row roles via \verb{$set_col_roles()} or \verb{$set_row_roles()}, respectively.
They are an alternative to directly accessing \verb{$col_roles} or \verb{$row_roles}, with the same side effects.
\item \verb{$select()} and \verb{$filter()} subset the set of active features or rows in \verb{$col_roles} or \verb{$row_roles}, respectively.
\item \verb{$cbind()} and \verb{$rbind()} change the task in-place by binding new columns or rows to the data.
\item \verb{$rename()} changes column names.
\item \verb{$set_levels()} and \verb{$droplevels()} update the field \verb{$col_info()} to automatically repair factor levels while querying data with \verb{$data()}.
}
}

\examples{
# We use the inherited class TaskClassif here,
# because the base class `Task` is not intended for direct use
task = TaskClassif$new("penguings", palmerpenguins::penguins, target = "species")

task$nrow
task$ncol
task$feature_names
task$formula()

# de-select "year"
task$select(setdiff(task$feature_names, "year"))

task$feature_names

# Add new column "foo"
task$cbind(data.frame(foo = 1:344))
head(task)
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{TaskClassif}},
\code{\link{TaskRegr}},
\code{\link{TaskSupervised}},
\code{\link{TaskUnsupervised}},
\code{\link{california_housing}},
\code{\link{mlr_tasks}},
\code{\link{mlr_tasks_breast_cancer}},
\code{\link{mlr_tasks_german_credit}},
\code{\link{mlr_tasks_iris}},
\code{\link{mlr_tasks_mtcars}},
\code{\link{mlr_tasks_penguins}},
\code{\link{mlr_tasks_pima}},
\code{\link{mlr_tasks_sonar}},
\code{\link{mlr_tasks_spam}},
\code{\link{mlr_tasks_wine}},
\code{\link{mlr_tasks_zoo}}
}
\concept{Task}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{label}}{(\code{character(1)})\cr
Label for this object.
Can be used in tables, plot and text output instead of the ID.}

\item{\code{task_type}}{(\code{character(1)})\cr
Task type, e.g. \code{"classif"} or \code{"regr"}.

For a complete list of possible task types (depending on the loaded packages),
see \code{\link[=mlr_reflections]{mlr_reflections$task_types$type}}.}

\item{\code{backend}}{(\link{DataBackend})\cr
Abstract interface to the data of the task.}

\item{\code{col_info}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Table with with 4 columns, mainly for internal purposes:
\itemize{
\item \code{"id"} (\code{character()}) stores the name of the column.
\item \code{"type"} (\code{character()}) holds the storage type of the variable, e.g. \code{integer}, \code{numeric} or \code{character}.
See \link[=mlr_reflections]{mlr_reflections$task_feature_types} for a complete list of allowed types.
\item \code{"levels"} (\code{list()}) stores a vector of distinct values (levels) for ordered and unordered factor variables.
\item \code{"label"} (\code{character()}) stores a vector of prettier, formated column names.
\item \code{"fix_factor_levels"} (\code{logical()}) stores flags which determine if the levels of the respective variable
need to be reordered after querying the data from the \link{DataBackend}.
}

Note that all columns of the \link{DataBackend}, also columns which are not selected or have any role, are listed
in this table.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
Defaults to \code{NA}, but can be set by child classes.}

\item{\code{extra_args}}{(named \code{list()})\cr
Additional arguments set during construction.
Required for \code{\link[=convert_task]{convert_task()}}.}

\item{\code{mlr3_version}}{(\code{package_version})\cr
Package version of \code{mlr3} used to create the task.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.
Used in tables, plot and text output.}

\item{\code{internal_valid_task}}{(\code{Task} or \code{integer()} or \code{NULL})\cr
Optional validation task that can, e.g., be used for early stopping with learners such as XGBoost.
See also the \verb{$validate} field of \code{\link{Learner}}.
If integers are assigned they are removed from the primary task and an internal validation task
with those ids is created from the primary task using only those ids.
When assigning a new task, it is always cloned.}

\item{\code{hash}}{(\code{character(1)})\cr
Hash (unique identifier) for this object.
The hash is calculated based on the complete task object and \verb{$row_ids}.
If an internal validation task is set, the hash is recalculated.}

\item{\code{row_ids}}{(positive \code{integer()})\cr
Returns the row ids of the \link{DataBackend} for observations with role "use".}

\item{\code{row_names}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Returns a table with two columns:
\itemize{
\item \code{"row_id"} (\code{integer()}), and
\item \code{"row_name"} (\code{character()}).
}}

\item{\code{feature_names}}{(\code{character()})\cr
Returns all column names with \code{role == "feature"}.

Note that this vector determines the default order of columns for \code{task$data(cols = NULL, ...)}.
However, it is recommended to \strong{not} rely on the order of columns, but instead always
address columns by their name. The default order is not well defined after some
operations, e.g. after \code{task$cbind()} or after processing via \CRANpkg{mlr3pipelines}.}

\item{\code{target_names}}{(\code{character()})\cr
Returns all column names with role "target".}

\item{\code{properties}}{(\code{character()})\cr
Set of task properties.
Possible properties are are stored in \link[=mlr_reflections]{mlr_reflections$task_properties}.
The following properties are currently standardized and understood by tasks in \CRANpkg{mlr3}:
\itemize{
\item \code{"strata"}: The task is resampled using one or more stratification variables (role \code{"stratum"}).
\item \code{"groups"}: The task comes with grouping/blocking information (role \code{"group"}).
\item \code{"weights"}: The task comes with observation weights (role \code{"weight"}).
}

Note that above listed properties are calculated from the \verb{$col_roles} and may not be set explicitly.}

\item{\code{row_roles}}{(named \code{list()})\cr
Each row (observation) can have an arbitrary number of roles in the learning task:
\itemize{
\item \code{"use"}: Use in train / predict / resampling.
}

\code{row_roles} is a named list whose elements are named by row role and each element is an \code{integer()} vector of row ids.
To alter the roles, just modify the list, e.g. with  \R's set functions (\code{\link[=intersect]{intersect()}}, \code{\link[=setdiff]{setdiff()}}, \code{\link[=union]{union()}}, \ldots).}

\item{\code{col_roles}}{(named \code{list()})\cr
Each column can be in one or more of the following groups to fulfill different roles:
\itemize{
\item \code{"feature"}: Regular feature used in the model fitting process.
\item \code{"target"}: Target variable. Most tasks only accept a single target column.
\item \code{"name"}: Row names / observation labels. To be used in plots. Can be queried with \verb{$row_names}.
Not more than a single column can be associated with this role.
\item \code{"order"}: Data returned by \verb{$data()} is ordered by this column (or these columns).
Columns must be sortable with \code{\link[=order]{order()}}.
\item \code{"group"}: During resampling, observations with the same value of the variable with role "group" are marked as "belonging together".
For each resampling iteration, observations of the same group will be exclusively assigned to be either in the training set or in the test set.
Not more than a single column can be associated with this role.
\item \code{"stratum"}: Stratification variables. Multiple discrete columns may have this role.
\item \code{"weight"}: Observation weights. Not more than one numeric column may have this role.
}

\code{col_roles} is a named list whose elements are named by column role and each element is a \code{character()} vector of column names.
To alter the roles, just modify the list, e.g. with \R's set functions (\code{\link[=intersect]{intersect()}}, \code{\link[=setdiff]{setdiff()}}, \code{\link[=union]{union()}}, \ldots).
The method \verb{$set_col_roles} provides a convenient alternative to assign columns to roles.}

\item{\code{nrow}}{(\code{integer(1)})\cr
Returns the total number of rows with role "use".}

\item{\code{ncol}}{(\code{integer(1)})\cr
Returns the total number of columns with role "target" or "feature".}

\item{\code{n_features}}{(\code{integer(1)})\cr
Returns the total number of columns with role "feature" (i.e. the number of "active" features in the task).}

\item{\code{feature_types}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Returns a table with columns \code{id} and \code{type} where \code{id} are the column names of "active"
features of the task and \code{type} is the storage type.}

\item{\code{data_formats}}{(\code{character()})\cr
Supported data format. Always \code{"data.table"}..
This is deprecated and will be removed in the future.}

\item{\code{strata}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has columns designated with role \code{"stratum"}, returns a table with one subpopulation per row and two columns:
\itemize{
\item \code{N} (\code{integer()}) with the number of observations in the subpopulation, and
\item \code{row_id} (list of \code{integer()}) as list column with the row ids in the respective subpopulation.
Returns \code{NULL} if there are is no stratification variable.
See \link{Resampling} for more information on stratification.
}}

\item{\code{groups}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has a column with designated role \code{"group"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item grouping variable \code{group} (\code{vector()}).
}

Returns \code{NULL} if there are is no grouping column.
See \link{Resampling} for more information on grouping.}

\item{\code{order}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has at least one column with designated role \code{"order"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item ordering vector \code{order} (\code{integer()}).
}

Returns \code{NULL} if there are is no order column.}

\item{\code{weights}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
If the task has a column with designated role \code{"weight"}, a table with two columns:
\itemize{
\item \code{row_id} (\code{integer()}), and
\item observation weights \code{weight} (\code{numeric()}).
}

Returns \code{NULL} if there are is no weight column.}

\item{\code{labels}}{(named \code{character()})\cr
Retrieve \code{labels} (prettier formated names) from columns.
Internally queries the column \code{label} of the table in field \code{col_info}.
Columns ids referenced by the name of the vector, the labels are the actual string values.

Assigning to this column update the task by reference.
You have to provide a character vector of labels, named with column ids.
To remove a label, set it to \code{NA}.
Alternatively, you can provide a \code{\link[=data.frame]{data.frame()}} with the two columns
\code{"id"} and \code{"label"}.}

\item{\code{col_hashes}}{(named \code{character})\cr
Hash (unique identifier) for all columns except the \code{primary_key}: A \code{character} vector, named by the columns that each element refers to.\cr
Columns of different \code{\link{Task}}s or \code{\link{DataBackend}}s that have agreeing \code{col_hashes} always represent the same data, given that the same \code{row}s are selected.
The reverse is not necessarily true: There can be columns with the same content that have different \code{col_hashes}.}

\item{\code{characteristics}}{(\code{list()})\cr
List of characteristics of the task, e.g. \code{list(n = 5, p = 7)}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Task-new}{\code{Task$new()}}
\item \href{#method-Task-divide}{\code{Task$divide()}}
\item \href{#method-Task-help}{\code{Task$help()}}
\item \href{#method-Task-format}{\code{Task$format()}}
\item \href{#method-Task-print}{\code{Task$print()}}
\item \href{#method-Task-data}{\code{Task$data()}}
\item \href{#method-Task-formula}{\code{Task$formula()}}
\item \href{#method-Task-head}{\code{Task$head()}}
\item \href{#method-Task-levels}{\code{Task$levels()}}
\item \href{#method-Task-missings}{\code{Task$missings()}}
\item \href{#method-Task-filter}{\code{Task$filter()}}
\item \href{#method-Task-select}{\code{Task$select()}}
\item \href{#method-Task-rbind}{\code{Task$rbind()}}
\item \href{#method-Task-cbind}{\code{Task$cbind()}}
\item \href{#method-Task-rename}{\code{Task$rename()}}
\item \href{#method-Task-set_row_roles}{\code{Task$set_row_roles()}}
\item \href{#method-Task-set_col_roles}{\code{Task$set_col_roles()}}
\item \href{#method-Task-set_levels}{\code{Task$set_levels()}}
\item \href{#method-Task-droplevels}{\code{Task$droplevels()}}
\item \href{#method-Task-add_strata}{\code{Task$add_strata()}}
\item \href{#method-Task-clone}{\code{Task$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-new"></a>}}
\if{latex}{\out{\hypertarget{method-Task-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.

Note that this object is typically constructed via a derived classes, e.g. \link{TaskClassif} or \link{TaskRegr}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$new(id, task_type, backend, label = NA_character_, extra_args = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{task_type}}{(\code{character(1)})\cr
Type of task, e.g. \code{"regr"} or \code{"classif"}.
Must be an element of \link[=mlr_reflections]{mlr_reflections$task_types$type}.}

\item{\code{backend}}{(\link{DataBackend})\cr
Either a \link{DataBackend}, or any object which is convertible to a \link{DataBackend} with \code{as_data_backend()}.
E.g., a \code{data.frame()} will be converted to a \link{DataBackendDataTable}.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}

\item{\code{extra_args}}{(named \code{list()})\cr
Named list of constructor arguments, required for converting task types
via \code{\link[=convert_task]{convert_task()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-divide"></a>}}
\if{latex}{\out{\hypertarget{method-Task-divide}{}}}
\subsection{Method \code{divide()}}{
Deprecated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$divide(ratio = NULL, ids = NULL, remove = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ratio}}{(\code{numeric(1)})\cr
The proportion of datapoints to use as validation data.}

\item{\code{ids}}{(\code{integer()})\cr
The row ids to use as validation data.}

\item{\code{remove}}{(\code{logical(1)})\cr
If \code{TRUE} (default), the \code{row_ids} are removed from the primary task's active \code{"use"} rows, ensuring a
disjoint split between the train and validation data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified \code{Self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-help"></a>}}
\if{latex}{\out{\hypertarget{method-Task-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-format"></a>}}
\if{latex}{\out{\hypertarget{method-Task-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-print"></a>}}
\if{latex}{\out{\hypertarget{method-Task-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-data"></a>}}
\if{latex}{\out{\hypertarget{method-Task-data}{}}}
\subsection{Method \code{data()}}{
Returns a slice of the data from the \link{DataBackend} as a \code{data.table}.
Rows default to observations with role \code{"use"}, and
columns default to features with roles \code{"target"} or \code{"feature"}.
If \code{rows} or \code{cols} are specified which do not exist in the \link{DataBackend},
an exception is raised.

Rows and columns are returned in the order specified via the arguments \code{rows} and \code{cols}.
If \code{rows} is \code{NULL}, rows are returned in the order of \code{task$row_ids}.
If \code{cols} is \code{NULL}, the column order defaults to
\code{c(task$target_names, task$feature_names)}.
Note that it is recommended to \strong{not} rely on the order of columns, and instead always
address columns with their respective column name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$data(rows = NULL, cols = NULL, data_format, ordered = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{(positive \code{integer()})\cr
Vector or row indices.
Always refers to the complete data set, even after filtering.}

\item{\code{cols}}{(\code{character()})\cr
Vector of column names.}

\item{\code{data_format}}{(\code{character(1)})\cr
Deprecated. Ignored, and will be removed in the future.}

\item{\code{ordered}}{(\code{logical(1)})\cr
If \code{TRUE}, data is ordered according to the columns with column role \code{"order"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Depending on the \link{DataBackend}, but usually a \code{\link[data.table:data.table]{data.table::data.table()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-formula"></a>}}
\if{latex}{\out{\hypertarget{method-Task-formula}{}}}
\subsection{Method \code{formula()}}{
Constructs a \code{\link[=formula]{formula()}}, e.g. \verb{[target] ~ [feature_1] + [feature_2] + ... + [feature_k]},
using the features provided in argument \code{rhs} (defaults to all columns with role \code{"feature"}, symbolized by \code{"."}).

Note that it is currently not possible to change the formula.
However, \CRANpkg{mlr3pipelines} provides a pipe operator interfacing \code{\link[stats:model.matrix]{stats::model.matrix()}} for this purpose: \code{"modelmatrix"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$formula(rhs = ".")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rhs}}{(\code{character(1)})\cr
Right hand side of the formula. Defaults to \code{"."} (all features of the task).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[=formula]{formula()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-head"></a>}}
\if{latex}{\out{\hypertarget{method-Task-head}{}}}
\subsection{Method \code{head()}}{
Get the first \code{n} observations with role \code{"use"} of all columns with role \code{"target"} or \code{"feature"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$head(n = 6L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-levels"></a>}}
\if{latex}{\out{\hypertarget{method-Task-levels}{}}}
\subsection{Method \code{levels()}}{
Returns the distinct values for columns referenced in \code{cols} with storage type "factor" or "ordered".
Argument \code{cols} defaults to all such columns with role \code{"target"} or \code{"feature"}.

Note that this function ignores the row roles, it returns all levels available in the \link{DataBackend}.
To update the stored level information, e.g. after subsetting a task with \verb{$filter()}, call \verb{$droplevels()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$levels(cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Vector of column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named \code{list()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-missings"></a>}}
\if{latex}{\out{\hypertarget{method-Task-missings}{}}}
\subsection{Method \code{missings()}}{
Returns the number of missing observations for columns referenced in \code{cols}.
Considers only active rows with row role \code{"use"}.
Argument \code{cols} defaults to all columns with role "target" or "feature".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$missings(cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Vector of column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{integer()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-filter"></a>}}
\if{latex}{\out{\hypertarget{method-Task-filter}{}}}
\subsection{Method \code{filter()}}{
Subsets the task, keeping only the rows specified via row ids \code{rows}.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$filter(rows)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{(positive \code{integer()})\cr
Vector or row indices.
Always refers to the complete data set, even after filtering.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-select"></a>}}
\if{latex}{\out{\hypertarget{method-Task-select}{}}}
\subsection{Method \code{select()}}{
Subsets the task, keeping only the features specified via column names \code{cols}.
Note that you cannot deselect the target column, for obvious reasons.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$select(cols)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Vector of column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-rbind"></a>}}
\if{latex}{\out{\hypertarget{method-Task-rbind}{}}}
\subsection{Method \code{rbind()}}{
Adds additional rows to the \link{DataBackend} stored in \verb{$backend}.
New row ids are automatically created, unless \code{data} has a column whose name matches
the primary key of the \link{DataBackend} (\code{task$backend$primary_key}).
In case of name clashes of row ids, rows in \code{data} have higher precedence
and virtually overwrite the rows in the \link{DataBackend}.

All columns with the roles \code{"target"}, \code{"feature"}, \code{"weight"}, \code{"group"}, \code{"stratum"},
and \code{"order"} must be present in \code{data}.
Columns only present in \code{data} but not in the \link{DataBackend} of \code{task} will be discarded.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$rbind(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{data.frame()}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-cbind"></a>}}
\if{latex}{\out{\hypertarget{method-Task-cbind}{}}}
\subsection{Method \code{cbind()}}{
Adds additional columns to the \link{DataBackend} stored in \verb{$backend}.

The row ids must be provided as column in \code{data} (with column name matching the primary key name of the \link{DataBackend}).
If this column is missing, it is assumed that the rows are exactly in the order of \verb{$row_ids}.
In case of name clashes of column names in \code{data} and \link{DataBackend}, columns in \code{data} have higher precedence
and virtually overwrite the columns in the \link{DataBackend}.

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$cbind(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{data.frame()}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-rename"></a>}}
\if{latex}{\out{\hypertarget{method-Task-rename}{}}}
\subsection{Method \code{rename()}}{
Renames columns by mapping column names in \code{old} to new column names in \code{new} (element-wise).

This operation mutates the task in-place.
See the section on task mutators for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$rename(old, new)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{old}}{(\code{character()})\cr
Old names.}

\item{\code{new}}{(\code{character()})\cr
New names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-set_row_roles"></a>}}
\if{latex}{\out{\hypertarget{method-Task-set_row_roles}{}}}
\subsection{Method \code{set_row_roles()}}{
Modifies the roles in \verb{$row_roles} \strong{in-place}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$set_row_roles(rows, roles = NULL, add_to = NULL, remove_from = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{(\code{integer()})\cr
Row ids for which to change the roles for.}

\item{\code{roles}}{(\code{character()})\cr
Exclusively set rows to the specified \code{roles} (remove from other roles).}

\item{\code{add_to}}{(\code{character()})\cr
Add rows with row ids \code{rows} to roles specified in \code{add_to}.
Rows keep their previous roles.}

\item{\code{remove_from}}{(\code{character()})\cr
Remove rows with row ids \code{rows} from roles specified in \code{remove_from}.
Other row roles are preserved.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Roles are first set exclusively (argument \code{roles}), then added (argument \code{add_to}) and finally
removed (argument \code{remove_from}) from different roles.
Duplicated row ids are explicitly allowed, so you can add replicate an observation by repeating its
\code{row_id}.
}

\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-set_col_roles"></a>}}
\if{latex}{\out{\hypertarget{method-Task-set_col_roles}{}}}
\subsection{Method \code{set_col_roles()}}{
Modifies the roles in \verb{$col_roles} \strong{in-place}.
See \verb{$col_roles} for a list of possible roles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$set_col_roles(cols, roles = NULL, add_to = NULL, remove_from = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Column names for which to change the roles for.}

\item{\code{roles}}{(\code{character()})\cr
Exclusively set columns to the specified \code{roles} (remove from other roles).}

\item{\code{add_to}}{(\code{character()})\cr
Add columns with column names \code{cols} to roles specified in \code{add_to}.
Columns keep their previous roles.}

\item{\code{remove_from}}{(\code{character()})\cr
Remove columns with columns names \code{cols} from roles specified in \code{remove_from}.
Other column roles are preserved.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Roles are first set exclusively (argument \code{roles}), then added (argument \code{add_to}) and finally removed (argument \code{remove_from}) from different roles.
Duplicated columns are removed from the same role.
For tasks that only allow one target, the target column cannot be set with \verb{$set_col_roles()}.
Use the \verb{$col_roles} field to swap the target column.
}

\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-set_levels"></a>}}
\if{latex}{\out{\hypertarget{method-Task-set_levels}{}}}
\subsection{Method \code{set_levels()}}{
Set levels for columns of type \code{factor} and \code{ordered} in field \code{col_info}.
You can add, remove or reorder the levels, affecting the data returned by
\verb{$data()} and \verb{$levels()}.
If you just want to remove unused levels, use \verb{$droplevels()} instead.

Note that factor levels which are present in the data but not listed in the task as
valid levels are converted to missing values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$set_levels(levels)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levels}}{(named \code{list()} of \code{character()})\cr
List of character vectors of new levels, named by column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-droplevels"></a>}}
\if{latex}{\out{\hypertarget{method-Task-droplevels}{}}}
\subsection{Method \code{droplevels()}}{
Updates the cache of stored factor levels, removing all levels not present in the current set of active rows.
\code{cols} defaults to all columns with storage type "factor" or "ordered".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$droplevels(cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Vector of column names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-add_strata"></a>}}
\if{latex}{\out{\hypertarget{method-Task-add_strata}{}}}
\subsection{Method \code{add_strata()}}{
Cuts numeric variables into new factors columns which are added to the task with role
\code{"stratum"}.
This ensures that all training and test splits contain observations from all bins.
The columns are named \code{"..stratum_[col_name]"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$add_strata(cols, bins = 3L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{(\code{character()})\cr
Names of columns to operate on.}

\item{\code{bins}}{(\code{integer()})\cr
Number of bins to cut into (passed to \code{\link[=cut]{cut()}} as \code{breaks}).
Replicated to have the same length as \code{cols}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Task-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Task-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Task$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
