% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_spam.R
\name{mlr_tasks_spam}
\alias{mlr_tasks_spam}
\title{Spam Classification Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.
}
\source{
Creators:
Mark Hopkins, Erik Reeber, George Forman, Jaap Suermondt.
Hewlett-Packard Labs, 1501 Page Mill Rd., Palo Alto, CA 94304

Donor:
George Forman (gforman at nospam hpl.hp.com) 650-857-7835

Preprocessing:
Columns have been renamed. Preprocessed data taken from the \CRANpkg{kernlab} package.
}
\description{
Spam data set from the UCI machine learning repository (\url{http://archive.ics.uci.edu/ml/datasets/spambase}).
Data set collected at Hewlett-Packard Labs to classify emails as spam or non-spam.
57 variables indicate the frequency of certain words and characters in the e-mail.
The positive class is set to "spam".
}
\section{Dictionary}{

This \link{Task} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_tasks} or with the associated sugar function \code{\link[=tsk]{tsk()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("spam")
tsk("spam")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Dimensions: 4601x58
\item Properties: \dQuote{twoclass}
\item Has Missings: \code{FALSE}
\item Target: \dQuote{type}
\item Features: \dQuote{address}, \dQuote{addresses}, \dQuote{all}, \dQuote{business}, \dQuote{capitalAve}, \dQuote{capitalLong}, \dQuote{capitalTotal}, \dQuote{charDollar}, \dQuote{charExclamation}, \dQuote{charHash}, \dQuote{charRoundbracket}, \dQuote{charSemicolon}, \dQuote{charSquarebracket}, \dQuote{conference}, \dQuote{credit}, \dQuote{cs}, \dQuote{data}, \dQuote{direct}, \dQuote{edu}, \dQuote{email}, \dQuote{font}, \dQuote{free}, \dQuote{george}, \dQuote{hp}, \dQuote{hpl}, \dQuote{internet}, \dQuote{lab}, \dQuote{labs}, \dQuote{mail}, \dQuote{make}, \dQuote{meeting}, \dQuote{money}, \dQuote{num000}, \dQuote{num1999}, \dQuote{num3d}, \dQuote{num415}, \dQuote{num650}, \dQuote{num85}, \dQuote{num857}, \dQuote{order}, \dQuote{original}, \dQuote{our}, \dQuote{over}, \dQuote{parts}, \dQuote{people}, \dQuote{pm}, \dQuote{project}, \dQuote{re}, \dQuote{receive}, \dQuote{remove}, \dQuote{report}, \dQuote{table}, \dQuote{technology}, \dQuote{telnet}, \dQuote{will}, \dQuote{you}, \dQuote{your}
}
}

\references{
Dua, Dheeru, Graff, Casey (2017).
\dQuote{UCI Machine Learning Repository.}
\url{http://archive.ics.uci.edu/ml/}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#tasks}
\item Package \CRANpkg{mlr3data} for more toy tasks.
\item Package \CRANpkg{mlr3oml} for downloading tasks from \url{https://www.openml.org}.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}
\item \code{as.data.table(mlr_tasks)} for a table of available \link[=Task]{Tasks} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3fselect} and \CRANpkg{mlr3filters} for feature selection and feature filtering.
\item Extension packages for additional task types:
\itemize{
\item Unsupervised clustering: \CRANpkg{mlr3cluster}
\item Probabilistic supervised regression and survival analysis: \url{https://mlr3proba.mlr-org.com/}.
}
}

Other Task: 
\code{\link{TaskClassif}},
\code{\link{TaskRegr}},
\code{\link{TaskSupervised}},
\code{\link{TaskUnsupervised}},
\code{\link{Task}},
\code{\link{mlr_tasks_boston_housing}},
\code{\link{mlr_tasks_breast_cancer}},
\code{\link{mlr_tasks_german_credit}},
\code{\link{mlr_tasks_iris}},
\code{\link{mlr_tasks_mtcars}},
\code{\link{mlr_tasks_penguins}},
\code{\link{mlr_tasks_pima}},
\code{\link{mlr_tasks_sonar}},
\code{\link{mlr_tasks_wine}},
\code{\link{mlr_tasks_zoo}},
\code{\link{mlr_tasks}}
}
\concept{Task}
